modelTypes.su_T50 = 
{

	-- header

	name = "SU T-50",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "Scale turbine jet",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Scale",
	power = "Turbine",
	level = "Advanced",

	supportsTrainingGear = 0,


	nodeCount = 82,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 2.145,
			Weight = 9.0,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 18.257887, z = -5.174688 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.546505, vertical = 0.546505 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Jet_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Wood",

		geometry = 
		{

			"default",
			"lodo2",
			"default2",
			"default3",
			"default4",
			"default5",
			"default6",
			"left_flape2",
			"default7",
			"right_flape2",
			"default8",
			"polySurface2",
			"default9",
			"polySurface4",
			"default10",
			"default11",
			"default12",
			"trap_av_left_missile2",
			"default13",
			"trap_av_right_missile2",
			"default14",
			"trap_ar_left_missile2",
			"default15",
			"trap_ar_right_missile2",
			"default16",
			"left_trape_roue_av2",
			"default17",
			"right_trape_roue_av2",
			"default18",
			"default19",
			"default20",
			"default21",
			"default22",
			"default23",
			"default24",
			"default25",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "box", x = -0.214885, y = 18.099018, z = -48.352058, width = 116.89344, height = 3.610047, length = 10.294571, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision2", material = "Inherit", type = "box", x = -0.214885, y = 17.109676, z = -3.438226, width = 9.167773, height = 3.610047, length = 170.452225, rot_x = 0.016564, rot_y = 0.0, rot_z = 0.0, rot_w = 0.999863 },
		},

	},

	airfoils = 
	{

		{
			name = "Main wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 25.740618, y = 18.000002, z = -8.190193 },
				Length = 1.0725,
				Root_chord = 1.1583,
				Tip_chord = 0.1716,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 48.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Aileron",
					root_pivot = { x = 52.856022, y = 18.090826, z = -52.363201 },
					tip_pivot = { x = 41.234119, y = 17.989452, z = -50.144604 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.375375,
						Tip_distance = 0.203775,
						Root_chord = 0.1716,
						Tip_chord = 0.057915,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"left_aileron2",
						},

						{

							"right_aileron2",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Stabiliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 25.436153, y = 18.000002, z = -52.777618 },
				Length = 0.525525,
				Root_chord = 0.6006,
				Tip_chord = 0.15015,
				Airfoil = "Flat Profile",
				Incidence = -1.25,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 48.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Elevator",
					root_pivot = { x = 25.446199, y = 17.989206, z = -66.671677 },
					tip_pivot = { x = 37.802166, y = 18.314112, z = -66.537674 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.525525,
						Tip_distance = 0.0,
						Root_chord = 0.3003,
						Tip_chord = 0.246675,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"left_elevator2",
							"rigth_elevator2",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Right fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = -20.42889, y = 22.021997, z = -45.609737 },
				Length = 0.4719,
				Root_chord = 0.53625,
				Tip_chord = 0.1287,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 115.0,
				Sweep = 40.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = -20.759245, y = 22.674566, z = -59.728622 },
					tip_pivot = { x = -27.34095, y = 36.970398, z = -59.860744 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.45045,
						Tip_distance = 0.0,
						Root_chord = 0.22737,
						Tip_chord = 0.1287,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"right_rudder2",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Left fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 21.023418, y = 22.021997, z = -45.609737 },
				Length = 0.4719,
				Root_chord = 0.53625,
				Tip_chord = 0.1287,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 65.0,
				Sweep = 40.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = 21.42416, y = 22.855503, z = -59.736698 },
					tip_pivot = { x = 28.250431, y = 37.336704, z = -59.801197 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.45045,
						Tip_distance = 0.0,
						Root_chord = 0.22737,
						Tip_chord = 0.1287,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"left_rudder2",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "Left turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = 11.101213, y = 14.053662, z = 0.0 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 150.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust",
					position = { x = 12.448431, y = 19.13835, z = -74.576447 },
					vector = { x = 0.007467, y = 0.0, z = -0.999972 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "Right turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = -11.101216, y = 13.935559, z = 0.0 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 150.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust2",
					position = { x = -11.51721, y = 19.13835, z = -74.576447 },
					vector = { x = 0.007467, y = 0.0, z = -0.999972 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "trein_avant",
			root_pivot = { x = -2.152542, y = 16.410202, z = 20.346197 },
			tip_pivot = { x = 1.806724, y = 16.405067, z = 20.373615 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 1500.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 1.0, z = 0.0, angle = -90.0 },
			full = { x = 0.0, y = 1.0, z = 0.0, angle = -90.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"roue_avant2",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "avant_Wheel",
					pivot = { x = -0.000002, y = 2.241699, z = 18.958263 },
					axis = { x = 0.999954, y = -0.0, z = 0.0 },
					width = 3.661392,
					radius = 2.351904,

					sides =
					{
						{

						},

					},

				},

			},

		},

		{
			name = "roue_arrire",
			root_pivot = { x = 8.181788, y = 14.043933, z = -31.162947 },
			tip_pivot = { x = 12.876568, y = 14.080018, z = -31.170591 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 1500.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = -9.0, y = -0.0, z = 0.0, angle = -90.0 },
			full = { x = -9.0, y = -0.0, z = 0.0, angle = -90.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"left_roue2",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"right_roue2",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "left_Wheel",
					pivot = { x = 20.843191, y = 3.980381, z = -30.311447 },
					axis = { x = 1.0, y = -0.0, z = -0.0 },
					width = 3.952985,
					radius = 3.952985,

					sides =
					{
						{

						},

						{

						},

					},

				},

			},

		},

	},

	widgets = 
	{

		{
			name = "Rear gear flaps",
			root_pivot = { x = 21.523384, y = 16.09482, z = -23.273407 },
			tip_pivot = { x = 20.62561, y = 15.7196, z = -12.592431 },
			mirrored = 1,
			changeTime = 2000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = -82.0 },

			sides =
			{
				{

					geometry = 
					{

						"left_trape_roue_g2",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"righ_trape_roue_d2",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "Front gear flaps",
			root_pivot = { x = 2.651099, y = 12.59479, z = 19.300703 },
			tip_pivot = { x = 2.651616, y = 12.594789, z = 23.123562 },
			mirrored = 1,
			changeTime = 2000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = -90.0 },

			sides =
			{
				{

					geometry = 
					{

						"left_litle_trap_roue_av2",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"right_litle_trap_roue_av2",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "Front wheel support",
			root_pivot = { x = 1.776621, y = 12.936371, z = 11.471566 },
			tip_pivot = { x = -1.59069, y = 12.935707, z = 11.448145 },
			mirrored = 0,
			changeTime = 1500.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 18.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 18.0 },

			sides =
			{
				{

					geometry = 
					{

						"trap_ar_roue_av2",
					},

					collision = 
					{

					},

				},

			},

		},

	},

	pilots = 
	{

		{
			name = "Pilot",
			position = { x = -0.00162, y = 21.194145, z = 34.563118 },
			size = 0.484086,


			attributes =
			{
				Type = "Fighter_pilot",
			},

		},

	},

}