modelTypes.alpha_jet_turbine = 
{

	-- header

	name = "alpha jet turbine",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Scale",
	power = "Turbine",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 76,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.0,
			Weight = 3.0,
			Robustness = 100.0,
			Centre_of_gravity = { x = -0.002024, y = 36.71632, z = 43.643089 },
			Inertia = { yaw = 1.5, pitch = 1.5, roll = 1.5 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Jet_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 15.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Plastic",

		geometry = 
		{

			"default",
			"glass",
			"default2",
			"default3",
			"default4",
			"default5",
			"default6",
			"default7",
			"default8",
			"default9",
			"default10",
			"default11",
			"default12",
			"default13",
			"default14",
			"default15",
			"default16",
			"default17",
			"default18",
			"default19",
			"default20",
			"lodo1",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "box", x = -0.00057, y = 10.089273, z = 12.294557, width = 7.703505, height = 3.043685, length = 52.68523, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.006956, y = 23.176298, z = 150.009232, radius = 1.448649 },
			{ name = "New Collision3", material = "Inherit", type = "box", x = -0.004547, y = 18.33724, z = 98.053673, width = 7.358359, height = 2.703375, length = 65.710419, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision4", material = "Inherit", type = "sphere", x = -0.00437, y = 48.899364, z = 94.232994, radius = 2.263634 },
			{ name = "New Collision5", material = "Inherit", type = "sphere", x = -0.002669, y = 59.596081, z = 57.55862, radius = 2.747532 },
			{ name = "New Collision6", material = "Inherit", type = "box", x = 62.591808, y = 43.105267, z = -0.0, width = 118.351791, height = 4.946698, length = 5.526077, rot_x = -0.016158, rot_y = 0.313583, rot_z = -0.048855, rot_w = 0.948166 },
			{ name = "New Collision7", material = "Inherit", type = "box", x = -62.93478, y = 43.293598, z = 0.338795, width = 104.758858, height = 4.730038, length = 4.838665, rot_x = -0.017224, rot_y = -0.323775, rot_z = 0.050254, rot_w = 0.944642 },
			{ name = "New Collision8", material = "Inherit", type = "box", x = 33.255543, y = 36.446716, z = -114.26683, width = 55.168072, height = 2.762414, length = 3.390376, rot_x = -0.022638, rot_y = 0.274225, rot_z = -0.079096, rot_w = 0.95814 },
			{ name = "New Collision9", material = "Inherit", type = "box", x = -32.073597, y = 36.501377, z = -113.365158, width = 53.879822, height = 2.536678, length = 2.781279, rot_x = -0.021339, rot_y = -0.293677, rot_z = 0.069258, rot_w = 0.953154 },
			{ name = "New Collision10", material = "Inherit", type = "box", x = 0.005321, y = 78.598991, z = -114.744019, width = 10.573966, height = 3.867982, length = 63.412949, rot_x = 0.375086, rot_y = 0.0, rot_z = 0.0, rot_w = 0.92699 },
			{ name = "New Collision11", material = "Inherit", type = "sphere", x = 0.006677, y = 42.402065, z = -143.9785, radius = 2.158078 },
			{ name = "New Collision12", material = "Inherit", type = "sphere", x = 0.006965, y = 96.676369, z = -150.197052, radius = 2.459605 },
			{ name = "New Collision13", material = "Inherit", type = "sphere", x = 0.003443, y = 23.556698, z = -74.250702, radius = 2.204014 },
		},

	},

	airfoils = 
	{

		{
			name = "wings",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 8.574193, y = 49.779411, z = 41.156834 },
				Length = 1.27,
				Root_chord = 0.78,
				Tip_chord = 0.3,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = -7.0,
				Sweep = 36.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 75.304901, y = 41.298119, z = -42.27573 },
					tip_pivot = { x = 110.655899, y = 37.026939, z = -54.644855 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.44,
						Tip_distance = 0.0,
						Root_chord = 0.115,
						Tip_chord = 0.09,
						Min_travel = 50.0,
						Max_travel = 50.0,
					},

					sides =
					{
						{

							"left_aileron",
						},

						{

							"right_aileron",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "elevator",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 7.673532, y = 41.261032, z = -96.939049 },
				Length = 0.56,
				Root_chord = 0.37,
				Tip_chord = 0.2,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = -11.0,
				Sweep = 34.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 7.595585, y = 41.28796, z = -115.881195 },
					tip_pivot = { x = 35.422863, y = 35.904541, z = -115.804626 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.56,
						Tip_distance = 0.0,
						Root_chord = 0.37,
						Tip_chord = 0.2,
						Min_travel = 5.0,
						Max_travel = 5.0,
					},

					sides =
					{
						{

							"left_elevator",
							"right_elevator",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "rudder",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.003827, y = 47.915993, z = -82.522018 },
				Length = 0.75,
				Root_chord = 0.5,
				Tip_chord = 0.16,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 46.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = -0.133492, y = 48.326035, z = -117.662033 },
					tip_pivot = { x = -0.271175, y = 85.055115, z = -138.437225 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.54,
						Tip_distance = 0.215,
						Root_chord = 0.15,
						Tip_chord = 0.082,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "left Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = 14.769378, y = 28.138367, z = 0.0 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 100.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust",
					position = { x = 15.898829, y = 26.197954, z = -76.847931 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "right Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = -14.479676, y = 28.21673, z = 0.0 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 100.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

			},

		},

	},

	gear = 
	{

		{
			name = "front Gear",
			root_pivot = { x = 2.790569, y = 27.492199, z = 110.041313 },
			tip_pivot = { x = -7.067104, y = 27.492199, z = 110.042152 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 0.0, y = 0.0, z = -5.0, angle = 95.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"front_gear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "front Wheel",
					pivot = { x = -2.854908, y = 5.125336, z = 105.665314 },
					axis = { x = 1.0, y = 0.0, z = -0.0 },
					width = 5.253695,
					radius = 5.253695,

					sides =
					{
						{

							"front_wheel",
						},

					},

				},

			},

		},

		{
			name = "rear Gear",
			root_pivot = { x = 11.246361, y = 27.64257, z = -2.844391 },
			tip_pivot = { x = 20.172333, y = 27.681181, z = -3.702972 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = -14.0, y = -4.0, z = 30.0, angle = 80.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"left__rear_gear",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"right__rear_gear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "rear left Wheel",
					pivot = { x = 32.990669, y = 7.398506, z = -11.338949 },
					axis = { x = 1.000003, y = 0.0, z = -0.0 },
					width = 5.570176,
					radius = 7.405838,

					sides =
					{
						{

							"left__rear_wheel",
						},

						{

						},

					},

				},

				{
					name = "rear right Wheel",
					pivot = { x = -32.880962, y = 7.430994, z = -11.274673 },
					axis = { x = 1.000003, y = 0.0, z = -0.0 },
					width = 6.093433,
					radius = 7.409895,

					sides =
					{
						{

						},

						{

							"right__rear_wheel",
						},

					},

				},

			},

		},

	},

	widgets = 
	{

		{
			name = "left front trap",
			root_pivot = { x = 1.002861, y = 18.886835, z = 113.195412 },
			tip_pivot = { x = 0.941069, y = 18.980076, z = 133.250381 },
			mirrored = 0,
			changeTime = 3000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"left_front_trap",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "right front trap",
			root_pivot = { x = -5.028215, y = 19.332764, z = 112.955894 },
			tip_pivot = { x = -4.873148, y = 19.5886, z = 130.942154 },
			mirrored = 0,
			changeTime = 3000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"right_front_trap",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "rear front trap",
			root_pivot = { x = 0.057498, y = 17.655149, z = 99.998795 },
			tip_pivot = { x = 0.057593, y = 17.731577, z = 112.935249 },
			mirrored = 0,
			changeTime = 3000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -97.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"rear_front_trap",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "left rear trap 1",
			root_pivot = { x = 21.927343, y = 28.69709, z = 3.960246 },
			tip_pivot = { x = 21.546091, y = 29.059914, z = 29.16543 },
			mirrored = 0,
			changeTime = 3000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -49.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"left__rear_trap_1",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "left rear trap 2",
			root_pivot = { x = 22.445681, y = 24.470997, z = -13.662618 },
			tip_pivot = { x = 23.194616, y = 28.032427, z = -0.87818 },
			mirrored = 0,
			changeTime = 3000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -54.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"left__rear_trap_2",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "rigth rear trap 1",
			root_pivot = { x = -21.73514, y = 28.988018, z = 2.511007 },
			tip_pivot = { x = -21.787878, y = 29.160162, z = 27.35321 },
			mirrored = 0,
			changeTime = 3000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 49.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"right__rear_trap_1",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "right rear trap 2",
			root_pivot = { x = -22.562355, y = 24.585497, z = -13.578259 },
			tip_pivot = { x = -22.859644, y = 27.653605, z = -1.153442 },
			mirrored = 0,
			changeTime = 3000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 55.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"right__rear_trap_2",
					},

					collision = 
					{

					},

				},

			},

		},

	},

}