modelTypes.Typhoon3 = 
{

	-- header

	name = "Eurofighter Typhoon",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "Piewacket",
	revision = 5.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "Scale Turbine",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Scale",
	power = "Turbine",
	level = "Intermediate",

	supportsTrainingGear = 0,


	nodeCount = 68,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 2.2,
			Weight = 2.0,
			Robustness = 25.0,
			Centre_of_gravity = { x = -0.019856, y = 12.961284, z = -6.575164 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Jet_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 300.0,
			Aileron = 300.0,
			Rudder = 300.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 2.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 5.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Foam",

		geometry = 
		{

			"engine_parts",
			"Glass",
			"engine_rear",
			"Main_Parts",
			"Pilot_Head",
			"missile_3",
			"missile_1",
			"missile_2",
			"cockpit",
			"Main_Body_1",
			"Bits",
		},

		collision = 
		{

			{ name = "Main_Body_", material = "Inherit", type = "sphere", x = 0.10131, y = 11.730274, z = 26.088598, radius = 7.7595 },
		},

	},

	gear = 
	{

		{
			name = "MainGear",
			root_pivot = { x = 9.285049, y = 10.964022, z = -6.22156 },
			tip_pivot = { x = 9.265501, y = 10.964022, z = -20.551699 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 45.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 90.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"LeftWheelChromeBits",
						"LeftMainGearStem",
						"LeftMainScissor1",
						"LeftMainScissor2",
						"LeftMainGearBrake",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"RightWheelChromeBits",
						"RightMainGearStem",
						"RightMainScissor1",
						"RightMainScissor2",
						"RightMainGearBrake",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "MainWheel",
					pivot = { x = 9.985864, y = 3.858668, z = -13.285077 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 1.6061,
					radius = 2.008975,

					sides =
					{
						{

							"LeftTyre",
						},

						{

							"RightTyre2",
						},

					},

				},

			},

		},

		{
			name = "FrontGear",
			root_pivot = { x = -4.323319, y = 8.233299, z = 8.686247 },
			tip_pivot = { x = 4.462276, y = 8.233299, z = 8.687324 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 90.0 },
			full = { x = 0.0, y = 5.0, z = 0.0, angle = 90.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"FrontGearChromeBits",
						"FrontGearScissor1",
						"FrontGearScissor2",
						"FrontGearStem",
						"FrontGearBrake",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "FrontWheel",
					pivot = { x = 0.0, y = 2.421322, z = 9.109007 },
					axis = { x = 0.999999, y = -0.0, z = 0.0 },
					width = 1.272972,
					radius = 1.285938,

					sides =
					{
						{

							"FrontTyre2",
						},

					},

				},

			},

		},

	},

	propulsion = 
	{

		{
			name = "LeftTurbine",
			type = "turbine",

			attributes =
			{
				Position = { x = 0.100695, y = 11.8705, z = -36.799995 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 60.0,
				Spool_Time = 5.0,
				Engine = "Small turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

			},

		},

	},

	airfoils = 
	{

		{
			name = "MainWing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 4.228991, y = 10.963524, z = 6.754458 },
				Length = 0.86879,
				Root_chord = 0.840764,
				Tip_chord = 0.112102,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 53.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"LeftWingTop",
						"LeftWingBottom",
					},

					collision = 
					{

						{ name = "LeftWingTop2", material = "Inherit", type = "sphere", x = 19.065006, y = 10.946698, z = -9.187926, radius = 4.111955 },
						{ name = "LeftWingBottom2", material = "Inherit", type = "sphere", x = 23.848614, y = 10.832836, z = -26.034389, radius = 4.100409 },
					},

				},

				{

					geometry = 
					{

						"RightWingTop",
						"RightWingBottom",
					},

					collision = 
					{

						{ name = "RightWingTop2", material = "Inherit", type = "sphere", x = -18.875074, y = 10.879939, z = -9.065172, radius = 4.164224 },
						{ name = "RightWingBottom2", material = "Inherit", type = "sphere", x = -23.529737, y = 11.078433, z = -25.99737, radius = 4.232507 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Ailerons",
					root_pivot = { x = 6.543925, y = 11.024877, z = -26.291445 },
					tip_pivot = { x = 26.694244, y = 11.138532, z = -27.146786 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.74,
						Tip_distance = 0.046242,
						Root_chord = 0.11,
						Tip_chord = 0.063057,
						Min_travel = 30.0,
						Max_travel = 30.0,
					},

					sides =
					{
						{

							"LeftAileron",
							"LeftAileron2",
							"LeftFlap3",
							"LeftFlap4",
						},

						{

							"RightAileron",
							"RightAileron2",
							"RightFlap3",
							"RightFlap4",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Canards",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = -2.808759, y = 13.298038, z = 21.830328 },
				Length = 0.210191,
				Root_chord = 0.149936,
				Tip_chord = 0.056051,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 190.0,
				Sweep = 44.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Elevator",
					root_pivot = { x = 9.600222, y = 12.089403, z = 19.398821 },
					tip_pivot = { x = 2.604183, y = 13.323004, z = 19.341665 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.21,
						Tip_distance = 0.0,
						Root_chord = 0.15,
						Tip_chord = 0.05,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"LeftCanard",
						},

						{

							"RighCanard",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.0, y = 16.345772, z = -21.954615 },
				Length = 0.518471,
				Root_chord = 0.364331,
				Tip_chord = 0.098089,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 54.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Fin",
					},

					collision = 
					{

						{ name = "Fin2", material = "Inherit", type = "sphere", x = 0.101308, y = 26.782906, z = -41.525837, radius = 3.460302 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = 0.01729, y = 16.313251, z = -34.093266 },
					tip_pivot = { x = -0.004012, y = 27.877516, z = -41.680389 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.434395,
						Tip_distance = 0.084076,
						Root_chord = 0.098089,
						Tip_chord = 0.056051,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"Rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

}