modelTypes.Turbine_MIG_31 = 
{

	-- header

	name = "Turbine MIG 31",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Park-flier",
	power = "Turbine",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 77,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.0,
			Weight = 4.0,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 41.999889, z = -0.149243 },
			Inertia = { yaw = 1.5, pitch = 1.5, roll = 1.5 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "None",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 30.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 8.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 90.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Plastic",

		geometry = 
		{

			"default",
			"mig_31:Frame_mesh01",
			"default2",
			"MIG_31_Turbine:right_flap",
			"default3",
			"MIG_31_Turbine:left_flap",
			"default4",
			"default5",
			"default6",
			"default7",
			"default8",
			"default9",
			"default10",
			"default11",
			"default12",
			"default13",
			"default14",
			"default15",
			"default16",
			"default17",
			"MIG_31_Turbine:ar_verriere",
			"default18",
			"MIG_31_Turbine:Body",
			"default19",
			"default20",
			"default21",
			"default22",
			"default23",
			"default24",
			"default25",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "sphere", x = -0.006913, y = 31.834578, z = 149.078964, radius = 3.720488 },
			{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.005653, y = 32.999306, z = 121.903175, radius = 7.284035 },
			{ name = "New Collision3", material = "Inherit", type = "sphere", x = -0.004087, y = 33.775677, z = 88.127037, radius = 13.272536 },
			{ name = "New Collision4", material = "Inherit", type = "sphere", x = -0.003205, y = 54.739948, z = 69.104309, radius = 4.163557 },
			{ name = "New Collision5", material = "Inherit", type = "box", x = 17.190081, y = 16.069408, z = -112.130112, width = 2.96248, height = 3.296407, length = 34.576916, rot_x = 0.099094, rot_y = 0.00916, rot_z = 0.179022, rot_w = 0.978799 },
			{ name = "New Collision6", material = "Inherit", type = "box", x = -17.358702, y = 16.069408, z = -112.130112, width = 3.387294, height = 3.296407, length = 34.576916, rot_x = 0.102999, rot_y = -0.017682, rot_z = -0.14399, rot_w = 0.984045 },
			{ name = "New Collision7", material = "Inherit", type = "box", x = 58.690807, y = 37.265182, z = -50.119099, width = 87.308083, height = 3.598989, length = 16.703234, rot_x = 0.016384, rot_y = 0.366348, rot_z = -0.051689, rot_w = 0.928896 },
			{ name = "New Collision8", material = "Inherit", type = "box", x = -58.230663, y = 37.781742, z = -50.574333, width = 89.944153, height = 4.322724, length = 16.703234, rot_x = 0.02774, rot_y = -0.372, rot_z = 0.06424, rot_w = 0.925591 },
			{ name = "New Collision9", material = "Inherit", type = "box", x = 37.32774, y = 30.825396, z = -128.199402, width = 54.81078, height = 3.991429, length = 16.703234, rot_x = 0.0, rot_y = 0.436505, rot_z = 0.0, rot_w = 0.899702 },
			{ name = "New Collision10", material = "Inherit", type = "box", x = -36.559406, y = 30.825407, z = -126.806732, width = 59.234516, height = 3.949627, length = 16.703234, rot_x = 0.0, rot_y = -0.452645, rot_z = 0.0, rot_w = 0.891691 },
			{ name = "New Collision11", material = "Inherit", type = "box", x = 24.977514, y = 65.954506, z = -106.197472, width = 3.897078, height = 16.703234, length = 66.078033, rot_x = 0.293093, rot_y = -0.03084, rot_z = -0.083216, rot_w = 0.951956 },
			{ name = "New Collision12", material = "Inherit", type = "box", x = -25.098436, y = 66.15844, z = -106.48056, width = 3.190782, height = 16.703234, length = 66.886375, rot_x = 0.291496, rot_y = 0.019945, rot_z = 0.090303, rot_w = 0.952091 },
			{ name = "New Collision13", material = "Inherit", type = "sphere", x = 98.974487, y = 31.998575, z = -58.016048, radius = 3.44127 },
			{ name = "New Collision14", material = "Inherit", type = "sphere", x = -98.306587, y = 32.080891, z = -58.045547, radius = 3.375234 },
			{ name = "New Collision15", material = "Inherit", type = "sphere", x = 0.0, y = 35.601742, z = -150.625153, radius = 10.206044 },
			{ name = "New Collision16", material = "Inherit", type = "box", x = 0.0, y = 21.906973, z = 0.0, width = 42.325314, height = 4.460186, length = 126.20578, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision17", material = "Inherit", type = "sphere", x = 22.177256, y = 42.241814, z = 68.30584, radius = 4.160662 },
			{ name = "New Collision18", material = "Inherit", type = "sphere", x = -21.589346, y = 42.41925, z = 68.328186, radius = 4.230808 },
		},

	},

	airfoils = 
	{

		{
			name = "wings Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 23.57934, y = 41.799995, z = -8.574335 },
				Length = 1.0,
				Root_chord = 0.82,
				Tip_chord = 0.34,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = -7.5,
				Sweep = 42.5,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 60.984798, y = 36.597267, z = -90.352013 },
					tip_pivot = { x = 83.594948, y = 33.927742, z = -98.216576 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.31,
						Tip_distance = 0.18,
						Root_chord = 0.105,
						Tip_chord = 0.085,
						Min_travel = 40.0,
						Max_travel = 40.0,
					},

					sides =
					{
						{

							"MIG_31_Turbine:left_aileron",
						},

						{

							"MIG_31_Turbine:right_aileron",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "elevators Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 21.976536, y = 30.7999, z = -95.885735 },
				Length = 0.62,
				Root_chord = 0.42,
				Tip_chord = 0.16,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 52.5,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 20.955145, y = 31.149021, z = -124.491516 },
					tip_pivot = { x = 43.769028, y = 31.042316, z = -124.480286 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.62,
						Tip_distance = 0.0,
						Root_chord = 0.42,
						Tip_chord = 0.16,
						Min_travel = 5.0,
						Max_travel = 5.0,
					},

					sides =
					{
						{

							"MIG_31_Turbine:right_elevator",
							"MIG_31_Turbine:left_elevator",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "left rudder Airfoil",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 21.284824, y = 45.032646, z = -75.496056 },
				Length = 0.7,
				Root_chord = 0.64,
				Tip_chord = 0.12,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 80.0,
				Sweep = 55.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 21.508883, y = 45.362968, z = -123.968628 },
					tip_pivot = { x = 25.648062, y = 71.1828, z = -135.570572 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.46,
						Tip_distance = 0.24,
						Root_chord = 0.155,
						Tip_chord = 0.075,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"MIG_31_Turbine:left_rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "right rudder Airfoil2",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = -21.47772, y = 45.032646, z = -75.496056 },
				Length = 0.7,
				Root_chord = 0.64,
				Tip_chord = 0.12,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 100.0,
				Sweep = 55.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = -21.159037, y = 45.138592, z = -123.823097 },
					tip_pivot = { x = -25.84536, y = 71.082214, z = -135.528366 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.46,
						Tip_distance = 0.24,
						Root_chord = 0.155,
						Tip_chord = 0.075,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"MIG_31_Turbine:right_rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "left Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = 10.780149, y = 32.385834, z = -0.032162 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 100.0,
				Spool_Time = 5.0,
				Engine = "Turbo-fan",
				Volume_Tuning = 40.0,
				Pitch_Tuning = 50.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust",
					position = { x = -10.868176, y = 32.480446, z = -144.908951 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 500.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "right Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = -10.847064, y = 32.409714, z = -0.04191 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 250.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 200.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust2",
					position = { x = 10.940401, y = 32.42083, z = -145.01683 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 500.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "front Gear",
			root_pivot = { x = 4.775359, y = 27.01325, z = 58.05822 },
			tip_pivot = { x = -4.643269, y = 27.01325, z = 58.096321 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 0.0, y = 3.0, z = 0.0, angle = -90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"MIG_31_Turbine:front_gear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "front Wheel",
					pivot = { x = -0.002546, y = 3.824173, z = 54.903145 },
					axis = { x = 1.0, y = -0.0, z = 0.0 },
					width = 5.425745,
					radius = 3.808198,

					sides =
					{
						{

							"MIG_31_Turbine:train_d_attrissage:FrontWheels",
						},

					},

				},

			},

		},

		{
			name = "left rear Gear",
			root_pivot = { x = 17.732365, y = 24.501041, z = -47.784115 },
			tip_pivot = { x = 17.732365, y = 24.501041, z = -33.398621 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = -18.0, y = 16.0, z = 0.0, angle = 30.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"MIG_31_Turbine:left_gear",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"MIG_31_Turbine:right_gear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "rear right Wheel1",
					pivot = { x = 27.025347, y = 6.432581, z = -52.828018 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 2.933705,
					radius = 6.312401,

					sides =
					{
						{

							"MIG_31_Turbine:train_d_attrissage:LeftRearWheel",
						},

						{

							"MIG_31_Turbine:LeftRearWheel2",
						},

					},

				},

				{
					name = "rear right Wheel2",
					pivot = { x = 21.791891, y = 6.432589, z = -37.722141 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 2.933705,
					radius = 6.312401,

					sides =
					{
						{

							"MIG_31_Turbine:LeftRearWheel",
						},

						{

							"MIG_31_Turbine:LeftRearWheel1",
						},

					},

				},

			},

		},

		{
			name = "left front trap",
			root_pivot = { x = 3.928897, y = 22.04352, z = 30.510698 },
			tip_pivot = { x = 3.928152, y = 22.831556, z = 61.586445 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -95.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"MIG_31_Turbine:front_left_trap",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"MIG_31_Turbine:front_right_trap",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "rear left trap 1",
			root_pivot = { x = 22.839478, y = 29.654608, z = -33.354557 },
			tip_pivot = { x = 22.839478, y = 29.654608, z = -18.354549 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = -0.0, y = 0.0, z = 0.0, angle = -63.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"rear_left_trap_1",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"MIG_31_Turbine:right_trap_1",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "rear left trap 2",
			root_pivot = { x = 22.448311, y = 25.511992, z = -47.80014 },
			tip_pivot = { x = 22.448311, y = 25.511992, z = -33.488277 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = -0.8, y = -3.3, z = 0.0, angle = -109.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"MIG_31_Turbine:left_treap_2",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"MIG_31_Turbine:right_trap_2",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

	},

}