modelTypes.Su_37_Terminator_turbine = 
{

	-- header

	name = "Su-37_Terminator turbine",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Park-flier",
	power = "Turbine",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 79,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.0,
			Weight = 3.5,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 9.889797, z = 19.296955 },
			Inertia = { yaw = 1.5, pitch = 1.5, roll = 1.5 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "None",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 300.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 25.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Plastic",

		geometry = 
		{

			"default",
			"LOD0",
			"default2",
			"Eject_Seat01",
			"default3",
			"Pilot01",
			"default4",
			"Canopy01",
			"default5",
			"Glass_Canopy01",
			"default6",
			"EngineL01",
			"default7",
			"EngineR01",
			"default8",
			"Glass01",
			"default9",
			"Glass_HUD",
			"default10",
			"BrakeL01",
			"default11",
			"CanardL01",
			"default12",
			"CanardR01",
			"default13",
			"VoletL01",
			"default14",
			"VoletR01",
			"default15",
			"default16",
			"FlapL01",
			"default17",
			"FlapR01",
			"default18",
			"default19",
			"default20",
			"default21",
			"default22",
			"default23",
			"default24",
			"default25",
			"default26",
			"default27",
			"default28",
			"default29",
			"default30",
			"default31",
			"default32",
			"default33",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "box", x = 57.6507, y = 29.575146, z = -20.992336, width = 63.26878, height = 4.221941, length = 10.310774, rot_x = -0.007272, rot_y = 0.373676, rot_z = 0.002485, rot_w = 0.927528 },
			{ name = "New Collision2", material = "Inherit", type = "box", x = -57.208969, y = 29.46423, z = -21.058443, width = 63.242893, height = 4.285354, length = 10.344932, rot_x = 0.0, rot_y = -0.360987, rot_z = 0.0, rot_w = 0.932571 },
			{ name = "New Collision3", material = "Inherit", type = "box", x = 42.826744, y = 20.692869, z = -85.008026, width = 46.787907, height = 2.877553, length = 6.282192, rot_x = 0.0, rot_y = 0.381653, rot_z = 0.0, rot_w = 0.924306 },
			{ name = "New Collision4", material = "Inherit", type = "box", x = -42.707848, y = 20.688276, z = -84.994164, width = 47.113075, height = 2.949686, length = 6.211938, rot_x = 0.0, rot_y = -0.379519, rot_z = 0.0, rot_w = 0.925184 },
			{ name = "New Collision5", material = "Inherit", type = "box", x = 26.041302, y = 51.833157, z = -63.006908, width = 2.928897, height = 54.426529, length = 4.134252, rot_x = -0.349699, rot_y = 0.0, rot_z = 0.0, rot_w = 0.936862 },
			{ name = "New Collision6", material = "Inherit", type = "box", x = -26.03557, y = 51.843349, z = -63.033169, width = 2.506764, height = 54.37785, length = 3.999201, rot_x = -0.355372, rot_y = 0.0, rot_z = 0.0, rot_w = 0.934725 },
			{ name = "New Collision7", material = "Inherit", type = "sphere", x = -0.006305, y = 22.946653, z = 135.970779, radius = 2.38115 },
			{ name = "New Collision8", material = "Inherit", type = "sphere", x = -0.00506, y = 27.340694, z = 109.118401, radius = 8.268245 },
			{ name = "New Collision9", material = "Inherit", type = "sphere", x = -0.003532, y = 44.184258, z = 76.163055, radius = 2.893783 },
			{ name = "New Collision10", material = "Inherit", type = "sphere", x = 0.006113, y = 24.167273, z = -131.821548, radius = 2.741191 },
			{ name = "New Collision11", material = "Inherit", type = "box", x = 0.000713, y = 13.277627, z = -37.161251, width = 39.178734, height = 2.768527, length = 82.01252, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision12", material = "Inherit", type = "sphere", x = 14.790987, y = 21.860094, z = -107.722542, radius = 3.650453 },
			{ name = "New Collision13", material = "Inherit", type = "sphere", x = -15.90724, y = 21.774973, z = -107.722008, radius = 3.64739 },
			{ name = "New Collision14", material = "Inherit", type = "box", x = 29.492432, y = 28.221947, z = 26.235443, width = 32.021149, height = 2.365393, length = 7.796601, rot_x = 0.0, rot_y = 0.433337, rot_z = 0.0, rot_w = 0.901232 },
			{ name = "New Collision15", material = "Inherit", type = "box", x = -29.594736, y = 28.166433, z = 26.328197, width = 32.242924, height = 2.383214, length = 7.798164, rot_x = 0.0, rot_y = -0.429911, rot_z = 0.0, rot_w = 0.902871 },
		},

	},

	airfoils = 
	{

		{
			name = "wings Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 26.058174, y = 29.160006, z = 7.848798 },
				Length = 0.85,
				Root_chord = 0.65,
				Tip_chord = 0.23,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 42.700001,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "ailerons Control surface",
					root_pivot = { x = 71.128082, y = 29.057955, z = -61.592548 },
					tip_pivot = { x = 88.607513, y = 29.222965, z = -69.288696 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.237,
						Tip_distance = 0.0,
						Root_chord = 0.07,
						Tip_chord = 0.035,
						Min_travel = 70.0,
						Max_travel = 70.0,
					},

					sides =
					{
						{

							"AileronL01",
						},

						{

							"AileronR01",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "elevators Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 26.346102, y = 20.386072, z = -66.529091 },
				Length = 0.46,
				Root_chord = 0.42,
				Tip_chord = 0.15,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 44.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "elevators Control surface",
					root_pivot = { x = 26.355574, y = 20.250967, z = -90.079155 },
					tip_pivot = { x = 50.386433, y = 20.250998, z = -89.859352 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.46,
						Tip_distance = 0.0,
						Root_chord = 0.419,
						Tip_chord = 0.15,
						Min_travel = 10.0,
						Max_travel = 10.0,
					},

					sides =
					{
						{

							"ElevatorL01",
							"ElevatorR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "left rudder Airfoil",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 26.283922, y = 29.588337, z = -43.666878 },
				Length = 0.55,
				Root_chord = 0.421,
				Tip_chord = 0.099,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 40.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "left rudder Control surface",
					root_pivot = { x = 26.171999, y = 28.075626, z = -74.233124 },
					tip_pivot = { x = 26.807182, y = 56.654728, z = -81.020485 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.37,
						Tip_distance = 0.2,
						Root_chord = 0.115,
						Tip_chord = 0.07,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"RudderL01",
						},

						{

						},

					},

				},

				{
					name = "right rudder Control surface",
					root_pivot = { x = -26.205948, y = 27.906309, z = -74.171646 },
					tip_pivot = { x = -26.259478, y = 56.34341, z = -80.787064 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.37,
						Tip_distance = 0.2,
						Root_chord = 0.115,
						Tip_chord = 0.07,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"RudderR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "right rudder Airfoil",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = -26.106966, y = 29.402805, z = -43.610012 },
				Length = 0.55,
				Root_chord = 0.421,
				Tip_chord = 0.099,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 40.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "left Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = 14.616299, y = 20.097376, z = -56.297836 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 60.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "left Exhaust",
					position = { x = 90.081421, y = 28.343693, z = -72.860062 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 50.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "right Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = -14.782393, y = 19.93128, z = -55.943775 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 60.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust",
					position = { x = -89.550026, y = 28.837538, z = -72.887222 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 50.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "front Gear",
			root_pivot = { x = 1.902374, y = 24.991589, z = 40.034256 },
			tip_pivot = { x = -1.87439, y = 24.991589, z = 40.005486 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 0.0, y = 6.0, z = 0.0, angle = 90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"train_d_attrissage:FrontGear",
						"train_d_attrissage:FrontAxleBar",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "New Wheel",
					pivot = { x = -0.065801, y = 4.241768, z = 38.514145 },
					axis = { x = 1.000001, y = -0.0, z = -0.0 },
					width = 8.374197,
					radius = 4.125441,

					sides =
					{
						{

							"train_d_attrissage:FrontWheels",
						},

					},

				},

			},

		},

		{
			name = "rear left Gear",
			root_pivot = { x = 25.628174, y = 22.800634, z = -31.547493 },
			tip_pivot = { x = 18.047102, y = 22.800634, z = -31.530678 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = -8.0, y = 0.0, z = -16.0, angle = 90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"train_d_attrissage:verrain_bas_train_g",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "New Wheel2",
					pivot = { x = 26.757412, y = 5.675278, z = -30.616135 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 3.985155,
					radius = 5.602939,

					sides =
					{
						{

							"train_d_attrissage:LeftRearWheel",
						},

					},

				},

			},

		},

		{
			name = "rear right Gear",
			root_pivot = { x = -18.770689, y = 22.034626, z = -31.515022 },
			tip_pivot = { x = -24.818464, y = 22.034626, z = -31.524559 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 8.5, y = 0.0, z = -16.0, angle = 90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"train_d_attrissage:verrain_bas_train_d",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "New Wheel",
					pivot = { x = -26.774002, y = 5.667522, z = -30.612469 },
					axis = { x = 1.0, y = 0.0, z = -0.0 },
					width = 3.957727,
					radius = 5.630875,

					sides =
					{
						{

							"train_d_attrissage:RightRearWheel",
						},

					},

				},

			},

		},

		{
			name = "front Gear 2",
			root_pivot = { x = 2.482141, y = 24.157013, z = 27.643921 },
			tip_pivot = { x = -2.418585, y = 24.157013, z = 27.618389 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 0.0, y = 4.0, z = 10.0, angle = 60.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"train_d_attrissage:FrontGearRearSupp",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

	},

	widgets = 
	{

		{
			name = "front trape Widget",
			root_pivot = { x = -3.212163, y = 24.093105, z = 25.368532 },
			tip_pivot = { x = -3.212163, y = 24.093105, z = 50.07851 },
			mirrored = 0,
			changeTime = 3000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 100.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"front_trap",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "rear trape",
			root_pivot = { x = 24.28861, y = 21.107857, z = -49.229961 },
			tip_pivot = { x = 24.28861, y = 21.107857, z = -24.679434 },
			mirrored = 1,
			changeTime = 3000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -66.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"rear_left_trap",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"rear_right_trap",
					},

					collision = 
					{

					},

				},

			},

		},

	},

}