modelTypes.Piper_Comanche2 = 
{

	-- header

	name = "Piper Comanche",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "Piewacket",
	revision = 2.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "Scale Glow Model",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Scale",
	power = "Glow",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 78,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.52,
			Weight = 2.27,
			Robustness = 40.0,
			Centre_of_gravity = { x = 0.0, y = 11.938784, z = 2.756957 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Modern",
		},

		Fine_tuning =
		{
			Thrust = 200.0,
			Lift = 400.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 15.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Foam",

		geometry = 
		{

			"Cylinders",
			"Engine",
			"EngineGrill",
			"Glass",
			"LeftHeadlight",
			"Other",
			"Pitot",
			"RightHeadlight",
			"Main_Fuselarge",
			"Headset",
			"Pilot",
		},

		collision = 
		{

			{ name = "Main_Fuselarge", material = "Inherit", type = "mesh", node = "Main_Fuselarge", x = 0.0, y = -0.000001, z = 0.000001, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
		},

	},

	airfoils = 
	{

		{
			name = "Wings",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 5.799999, y = 8.799996, z = 6.599996 },
				Length = 0.7296,
				Root_chord = 0.2888,
				Tip_chord = 0.14288,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 5.0,
				Sweep = 0.5,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"LeftWing",
					},

					collision = 
					{

						{ name = "LeftWing2", material = "Inherit", type = "mesh", node = "LeftWing", x = -0.000002, y = -0.000001, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

						"RightWing",
					},

					collision = 
					{

						{ name = "RightWing2", material = "Inherit", type = "mesh", node = "RightWing", x = 0.000002, y = -0.000001, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Ailerons",
					root_pivot = { x = 31.788605, y = 11.118205, z = -3.935185 },
					tip_pivot = { x = 51.540176, y = 12.851751, z = -0.552307 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.3116,
						Tip_distance = 0.0228,
						Root_chord = 0.05168,
						Tip_chord = 0.05016,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"LeftAileron",
						},

						{

							"RightAileron",
						},

					},

				},

			},

			flaps = {

				{
					name = "Flap",
					root_pivot = { x = 31.642235, y = 11.004218, z = -3.949342 },
					tip_pivot = { x = 14.650787, y = 9.251251, z = -6.663892 },
					is_leading_edge = 0,

					attributes =
					{
						Length = 0.2584,
						Root_Chord = 0.0608,
						Tip_Chord = 0.0532,
						Tip_distance = 0.3344,
						Travel = 20.0,
						Lift_increase = 50.0,
						Drag_increase = 25.0,
					},

					sides =
					{
						{

							"LeftFlap",
						},

						{

							"RightFlap",
						},

					},

				},

			},

			airbrakes = {

			},

		},

		{
			name = "Stabaliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.008977, y = 15.238744, z = -36.926414 },
				Length = 0.28576,
				Root_chord = 0.15352,
				Tip_chord = 0.08816,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 11.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Stabaliser",
					},

					collision = 
					{

						{ name = "Stabaliser2", material = "Inherit", type = "mesh", node = "Stabaliser", x = 0.0, y = -0.000002, z = 0.000004, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Elevator",
					root_pivot = { x = -17.270576, y = 15.183769, z = -44.879997 },
					tip_pivot = { x = 17.284042, y = 15.183769, z = -44.840454 },

					attributes =
					{
						Input = "Right Elevator",
						Length = 0.2736,
						Tip_distance = 0.0152,
						Root_chord = 0.0304,
						Tip_chord = 0.0228,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"Elevator",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "TailFin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.0, y = 16.679811, z = -31.110987 },
				Length = 0.25232,
				Root_chord = 0.20672,
				Tip_chord = 0.1064,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 40.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Tailfin",
					},

					collision = 
					{

						{ name = "Tailfin2", material = "Inherit", type = "mesh", node = "Tailfin", x = 0.0, y = -0.000002, z = 0.000004, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = -0.024602, y = 16.74358, z = -40.935139 },
					tip_pivot = { x = 0.009225, y = 28.279657, z = -44.429359 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.228,
						Tip_distance = 0.01976,
						Root_chord = 0.06384,
						Tip_chord = 0.06384,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"Rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "Propeller",
			type = "propeller",
			pivot = { x = 0.0, y = 12.936052, z = 26.156467 },
			angle = -29.025496,
			spinDirection = 1,
			pusher = 0,
			folding = 0,
			blurRadius = 1.885041,
			blurTexture = "None",

			attributes =
			{
				Position = { x = 0.0, y = 12.936052, z = 26.156467 },
				Diameter = 0.304,
				Pitch = 0.152,
				Blade_count = 3,
				Idle_RPM = 2000,
				Max_RPM = 10000,
				Down_thrust = 0.0,
				Right_thrust = 0.0,
				Torque = 100.0,
				Response = { load = 1.0, unload = 1.0 },
				Engine = "DA 150",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			spinGeometry = 
			{

				"Spinner",
			},

			blurGeometry = 
			{

				"Blades",
			},

			exhaust = 
			{

				{
					name = "Exhaust",
					position = { x = 1.482144, y = 6.138482, z = 12.575615 },
					vector = { x = 0.0, y = -0.501069, z = -0.865407 },

					attributes =
					{
						Engine_Smoke = 1,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "MainGear",
			root_pivot = { x = 13.864311, y = 7.72046, z = -5.134735 },
			tip_pivot = { x = 13.864311, y = 7.72046, z = 4.357508 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = -1.0, y = 0.8, z = -1.6, angle = -90.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 25.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"LeftGear",
					},

					collision = 
					{

						"LeftGear",
					},

				},

				{

					geometry = 
					{

						"RightGear",
					},

					collision = 
					{

						"RightGear",
					},

				},

			},

			wheels = 
			{

				{
					name = "MainWheels",
					pivot = { x = 13.848154, y = 3.555333, z = -0.645972 },
					axis = { x = 0.999996, y = -0.0, z = 0.0 },
					width = 1.519034,
					radius = 2.104311,

					sides =
					{
						{

							"LeftTyre",
						},

						{

							"RightTyre",
						},

					},

				},

			},

		},

		{
			name = "NoseGear",
			root_pivot = { x = -3.455431, y = 7.487738, z = 17.850555 },
			tip_pivot = { x = 3.347056, y = 7.487738, z = 17.865446 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 1.0, z = -1.0, angle = 115.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 25.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"FrontGear",
					},

					collision = 
					{

						"FrontGear",
					},

				},

			},

			wheels = 
			{

				{
					name = "NoseWheel",
					pivot = { x = 0.0, y = 2.892227, z = 18.640829 },
					axis = { x = 1.0, y = 0.0, z = -0.0 },
					width = 1.48528,
					radius = 2.142112,

					sides =
					{
						{

							"FrontTyre",
						},

					},

				},

			},

		},

	},

}