modelTypes.PC_21_Mk2 = 
{

	-- header

	name = "P-21 Pilatus",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "Piewacket",
	revision = 4.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "Scale Electric",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Scale",
	power = "Electric",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 80,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.52,
			Weight = 2.27,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 14.662108, z = 1.644737 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.03, lateral = 0.3, vertical = 0.3 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Modern",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Wood",

		geometry = 
		{

			"Main Fuselarge",
			"rubber",
			"radiator00",
			"spoiler",
			"rspoileron",
			"rdoor",
			"rbdoor",
			"lspoileron",
			"lightbox",
			"ldoor",
			"lbdoor",
			"arch",
			"antennas",
			"airbrake",
			"radiator",
			"exhaust",
			"canopy",
			"lights",
			"reflectors",
			"lgbox",
			"wavefront_",
			"wavefron19",
			"wavefron18",
			"wavefron17",
			"stick00015",
			"stick",
			"rect000000",
			"rect",
			"lever00002",
			"lever00001",
			"archi",
			"Seats",
			"Placeholde",
			"Placehol20",
			"FrontHub",
			"CPT-R-ped8",
			"CPT-R-ped5",
			"CPT-L-ped6",
			"CPT-L-pe10",
			"BackHub",
			"stick00014",
			"stick00012",
			"lever00003",
			"lever",
			"FPanel",
			"Cockpit",
			"CPT-R-peda",
			"CPT-R-ped7",
			"CPT-L-peda",
			"CPT-L-ped9",
			"BPanel",
			"hud2",
			"hud1",
			"displays",
			"stick00016",
			"stick00000",
			"lever00004",
			"lever00000",
			"stick00013",
			"stick00011",
		},

		collision = 
		{

			{ name = "Main Fuselarge Collision", material = "Inherit", type = "mesh", node = "Main Fuselarge", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
		},

	},

	airfoils = 
	{

		{
			name = "Main Wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 4.37881, y = 11.660007, z = 7.549731 },
				Length = 0.57,
				Root_chord = 0.29,
				Tip_chord = 0.15,
				Airfoil = "Funfly",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 3.8,
				Sweep = 13.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Left Wing",
					},

					collision = 
					{

						{ name = "Left Wing Collision", material = "Inherit", type = "mesh", node = "Left Wing", x = -0.000002, y = -0.000001, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

						"Right Wing",
					},

					collision = 
					{

						{ name = "Right Wing Collision", material = "Inherit", type = "mesh", node = "Right Wing", x = 0.000002, y = -0.000001, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Aileron",
					root_pivot = { x = 23.566708, y = 13.047941, z = -7.735721 },
					tip_pivot = { x = 36.187843, y = 13.680167, z = -8.142834 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.2,
						Tip_distance = 0.07,
						Root_chord = 0.055,
						Tip_chord = 0.044,
						Min_travel = 30.0,
						Max_travel = 30.0,
					},

					sides =
					{
						{

							"laileron",
						},

						{

							"raileron",
						},

					},

				},

			},

			flaps = {

				{
					name = "Flap",
					root_pivot = { x = 23.609974, y = 12.888927, z = -6.968654 },
					tip_pivot = { x = -23.937376, y = 13.012638, z = -7.065816 },
					is_leading_edge = 0,

					attributes =
					{
						Length = 0.325,
						Root_Chord = 0.086,
						Tip_Chord = 0.07,
						Tip_distance = 0.27,
						Travel = 20.0,
						Lift_increase = 50.0,
						Drag_increase = 30.0,
					},

					sides =
					{
						{

							"lflap",
						},

						{

							"rflap",
						},

					},

				},

			},

			airbrakes = {

			},

		},

		{
			name = "Stabaliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.021822, y = 20.104874, z = -46.50647 },
				Length = 0.285,
				Root_chord = 0.175,
				Tip_chord = 0.088,
				Airfoil = "Funfly",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 16.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = -1.5, max = -1.5 },
			},

			sides =
			{
				{

					geometry = 
					{

						"hstabilize",
					},

					collision = 
					{

						{ name = "hstabilize Collision", material = "Inherit", type = "mesh", node = "hstabilize", x = 0.0, y = -0.000002, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Eelevator",
					root_pivot = { x = -18.08473, y = 20.148376, z = -54.856117 },
					tip_pivot = { x = 17.995329, y = 20.099478, z = -54.447006 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.265,
						Tip_distance = 0.0,
						Root_chord = 0.045,
						Tip_chord = 0.045,
						Min_travel = 40.0,
						Max_travel = 40.0,
					},

					sides =
					{
						{

							"relevator",
						},

						{

							"lelevator",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = -0.211265, y = 20.140047, z = -38.087261 },
				Length = 0.31,
				Root_chord = 0.24,
				Tip_chord = 0.1,
				Airfoil = "Funfly",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 28.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"tail",
					},

					collision = 
					{

						{ name = "Tail collision", material = "Inherit", type = "mesh", node = "tail", x = 0.0, y = -0.000004, z = 0.000004, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = -0.142588, y = 21.870914, z = -48.027981 },
					tip_pivot = { x = -0.136981, y = 38.096653, z = -50.926437 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.28,
						Tip_distance = 0.0,
						Root_chord = 0.09,
						Tip_chord = 0.05,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "Propeller",
			type = "propeller",
			pivot = { x = -0.229401, y = 14.795959, z = 32.989185 },
			angle = -0.0,
			spinDirection = 1,
			pusher = 0,
			folding = 0,
			blurRadius = 10.523811,
			blurTexture = "None",

			attributes =
			{
				Position = { x = -0.229401, y = 14.795959, z = 32.989185 },
				Diameter = 0.32,
				Pitch = 0.2,
				Blade_count = 5,
				Idle_RPM = 0,
				Max_RPM = 10000,
				Down_thrust = 0.0,
				Right_thrust = 0.0,
				Torque = 100.0,
				Response = { load = 1.0, unload = 1.0 },
				Engine = "Light electric",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			spinGeometry = 
			{

				"spinner",
			},

			blurGeometry = 
			{

				"propeller",
			},

			exhaust = 
			{

			},

		},

	},

	gear = 
	{

		{
			name = "Main Gear",
			root_pivot = { x = 11.449938, y = 12.56278, z = -11.366897 },
			tip_pivot = { x = 11.487349, y = 11.676684, z = 5.751118 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 1500.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.8, y = -0.5, z = -0.7, angle = -90.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"lugear",
						"ldgear",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"rugear",
						"rdgear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "Left Wheels",
					pivot = { x = 11.404761, y = 4.235497, z = -2.420656 },
					axis = { x = 0.999999, y = -0.0, z = 0.0 },
					width = 1.0,
					radius = 2.392251,

					sides =
					{
						{

							"lwheel",
							"lhubcap",
							"ltyre",
						},

						{

							"rwheel",
							"rhubcap",
							"rtyre",
						},

					},

				},

			},

		},

		{
			name = "Front Gear",
			root_pivot = { x = -4.361122, y = 9.909317, z = 18.520634 },
			tip_pivot = { x = 3.921278, y = 9.929533, z = 18.509075 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 1500.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 3.0, z = 0.0, angle = 90.0 },

			attributes =
			{
				Guide_travel = 15.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"taxibox",
						"fuscissor",
						"fugear",
						"fgear",
						"ffstrut",
						"fdscissor",
						"fdgear",
						"fbstrut",
						"taxilights",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "Front Wheel",
					pivot = { x = -0.227195, y = 2.651672, z = 19.104218 },
					axis = { x = 1.000001, y = -0.0, z = 0.0 },
					width = 1.0,
					radius = 1.97103,

					sides =
					{
						{

							"ftyre",
							"fwheel",
						},

					},

				},

			},

		},

	},

	pilots = 
	{

		{
			name = "Oliver",
			position = { x = 0.0, y = 18.67688, z = 2.161058 },
			size = 0.5,


			attributes =
			{
				Type = "Racer",
			},

		},

		{
			name = "Stanley",
			position = { x = 0.0, y = 20.542736, z = -10.126779 },
			size = 0.5,


			attributes =
			{
				Type = "Racer",
			},

		},

	},

}