modelTypes.Mig_31_Foxhound = 
{

	-- header

	name = "Mig-31 Foxhound",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "Scale ducted-fan jet",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Electric",
	style = "Park-flier",
	power = "Electric",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 73,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 0.9,
			Weight = 2.5,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 20.873894, z = -14.99426 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.029793, lateral = 0.203609, vertical = 0.203609 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Jet_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Foam",

		geometry = 
		{

			"LOD0",
			"Glass",
			"EngineL01",
			"EngineR01",
			"Glass_HUD",
			"Canopy01",
			"Glass_Canopy01",
			"Canopy02",
			"Glass_Canopy02",
			"FlapL01",
			"FlapR01",
			"IntakeL01",
			"IntakeR01",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "sphere", x = -0.003773, y = 17.973482, z = 81.368362, radius = 1.644197 },
			{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.003004, y = 18.252142, z = 64.788116, radius = 4.1697 },
			{ name = "New Collision3", material = "Inherit", type = "sphere", x = -0.001383, y = 12.818294, z = 29.816427, radius = 2.7895 },
			{ name = "New Collision4", material = "Inherit", type = "sphere", x = -0.001912, y = 28.283861, z = 41.241444, radius = 2.7895 },
			{ name = "New Collision5", material = "Inherit", type = "sphere", x = 12.873498, y = 22.877716, z = 35.368629, radius = 2.7895 },
			{ name = "New Collision6", material = "Inherit", type = "sphere", x = -13.110129, y = 22.877716, z = 35.368629, radius = 2.7895 },
			{ name = "New Collision7", material = "Inherit", type = "sphere", x = -13.110129, y = 10.785498, z = 10.467865, radius = 2.7895 },
			{ name = "New Collision8", material = "Inherit", type = "sphere", x = 12.993599, y = 10.785498, z = 10.467865, radius = 2.7895 },
			{ name = "New Collision9", material = "Inherit", type = "sphere", x = 25.184921, y = 13.628221, z = -11.65984, radius = 1.463152 },
			{ name = "New Collision10", material = "Inherit", type = "sphere", x = -25.107632, y = 13.628221, z = -11.65984, radius = 1.463152 },
			{ name = "New Collision11", material = "Inherit", type = "sphere", x = -49.867897, y = 15.351798, z = -39.615452, radius = 3.540958 },
			{ name = "New Collision12", material = "Inherit", type = "sphere", x = 50.443581, y = 15.351798, z = -39.615452, radius = 3.540958 },
			{ name = "New Collision13", material = "Inherit", type = "sphere", x = 32.628719, y = 13.618877, z = -78.945267, radius = 3.540958 },
			{ name = "New Collision14", material = "Inherit", type = "sphere", x = -32.190018, y = 13.618877, z = -78.945267, radius = 3.540958 },
			{ name = "New Collision15", material = "Inherit", type = "sphere", x = 0.013772, y = 15.290186, z = -83.604568, radius = 7.095483 },
			{ name = "New Collision16", material = "Inherit", type = "sphere", x = 13.482788, y = 39.689083, z = -79.6334, radius = 1.487066 },
			{ name = "New Collision17", material = "Inherit", type = "sphere", x = 13.79675, y = 42.831631, z = -73.767311, radius = 1.487066 },
			{ name = "New Collision18", material = "Inherit", type = "sphere", x = -12.973322, y = 39.689083, z = -79.6334, radius = 1.487066 },
			{ name = "New Collision19", material = "Inherit", type = "sphere", x = -13.311209, y = 42.831631, z = -73.767311, radius = 1.487066 },
			{ name = "New Collision20", material = "Inherit", type = "sphere", x = -0.000097, y = 29.438608, z = 2.092075, radius = 1.562398 },
		},

	},

	airfoils = 
	{

		{
			name = "Main wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 6.008558, y = 15.939225, z = 2.588327 },
				Length = 0.55,
				Root_chord = 0.5,
				Tip_chord = 0.144,
				Airfoil = "NACA 2314",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 42.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Aileron",
					root_pivot = { x = 31.724672, y = 18.063433, z = -45.560696 },
					tip_pivot = { x = 45.451, y = 15.957516, z = -48.977512 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.1665,
						Tip_distance = 0.0765,
						Root_chord = 0.063,
						Tip_chord = 0.054,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"AileronL01",
						},

						{

							"AileronR01",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Stabiliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 11.612049, y = 14.048099, z = -53.115349 },
				Length = 0.297,
				Root_chord = 0.189,
				Tip_chord = 0.063,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 50.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Elevator",
					root_pivot = { x = 11.713248, y = 13.97915, z = -66.055542 },
					tip_pivot = { x = 22.347393, y = 14.127923, z = -66.257103 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.162,
						Tip_distance = 0.135,
						Root_chord = 0.072,
						Tip_chord = 0.1269,
						Min_travel = 30.0,
						Max_travel = 30.0,
					},

					sides =
					{
						{

							"ElevatorL01",
							"ElevatorR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Left fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 11.396337, y = 23.239141, z = -45.246925 },
				Length = 0.315,
				Root_chord = 0.279,
				Tip_chord = 0.0585,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 83.0,
				Sweep = 55.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = 11.295752, y = 22.47361, z = -69.143806 },
					tip_pivot = { x = 13.115705, y = 33.446022, z = -74.721848 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.1755,
						Tip_distance = 0.153,
						Root_chord = 0.063,
						Tip_chord = 0.0333,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"RudderL01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Right fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = -10.980704, y = 23.239141, z = -45.246925 },
				Length = 0.315,
				Root_chord = 0.279,
				Tip_chord = 0.0585,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 97.0,
				Sweep = 55.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = -10.923121, y = 22.458, z = -69.112839 },
					tip_pivot = { x = -12.743711, y = 33.49065, z = -74.814819 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.1755,
						Tip_distance = 0.153,
						Root_chord = 0.063,
						Tip_chord = 0.0333,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"RudderR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "Ducted fan",
			type = "turbine",

			attributes =
			{
				Position = { x = 0.0, y = 16.372238, z = 0.0 },
				Idle_RPM = 0.0,
				Max_RPM = 25000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 40.0,
				Spool_Time = 0.5,
				Engine = "Icon A5 electric",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

			},

		},

	},

	pilots = 
	{

		{
			name = "Front pilot",
			position = { x = -0.001708, y = 23.135757, z = 36.05442 },
			size = 0.555411,


			attributes =
			{
				Type = "Fighter_pilot",
			},

		},

		{
			name = "Rear pilot",
			position = { x = -0.001708, y = 22.16004, z = 23.939823 },
			size = 0.555411,


			attributes =
			{
				Type = "Fighter_pilot",
			},

		},

	},

	{
		name = "New Exhaust",
		position = { x = -5.545702, y = 15.320443, z = -77.866653 },
		vector = { x = -0.001852, y = 0.0, z = -0.999998 },

		attributes =
		{
			Engine_Smoke = 0,
			Engine_Smoke_Intensity = 100.0,
			Display_Smoke = 1,
			Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
		},

	},

	{
		name = "New Exhaust2",
		position = { x = 6.790669, y = 15.320443, z = -77.866653 },
		vector = { x = -0.001852, y = 0.0, z = -0.999998 },

		attributes =
		{
			Engine_Smoke = 0,
			Engine_Smoke_Intensity = 100.0,
			Display_Smoke = 1,
			Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
		},

	},

}