modelTypes.Lockheed_P38 = 
{

	-- header

	name = "Lockheed-P38",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.5.f",
	minProgramVersion = "5.0.a",
	description = "",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Scale",
	power = "Gasser",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 57,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.0,
			Weight = 10.0,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 9.371145, z = 29.712654 },
			Inertia = { yaw = 1.2, pitch = 1.2, roll = 1.2 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "WW2_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = { severity = 100.0, limit = 100.0, speed = 100.0 },
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Torque = 100.0,
			Ground_Torque_Effect = 100.0,
			Rudder_Roll_Coupling = 0.0,
			Rudder_Elevator_Coupling = 0.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 20.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 9.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Plastic",

		geometry = 
		{

			"default",
			"lodo",
			"default2",
			"default3",
			"default4",
			"default5",
			"default6",
			"default7",
			"default8",
			"default9",
			"default10",
			"default11",
			"default12",
			"default13",
			"default14",
			"default15",
			"default16",
			"default17",
			"default18",
			"default19",
			"default20",
			"default21",
			"default22",
			"default23",
			"default24",
			"default25",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "sphere", x = -0.005087, y = 30.761517, z = 109.709, radius = 3.690548 },
			{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.001945, y = 54.639282, z = 41.947468, radius = 0.5 },
			{ name = "New Collision3", material = "Inherit", type = "sphere", x = -48.602058, y = 72.407761, z = -104.115707, radius = 0.5 },
			{ name = "New Collision4", material = "Inherit", type = "sphere", x = 48.61171, y = 72.881226, z = -104.115738, radius = 0.5 },
			{ name = "New Collision5", material = "Inherit", type = "sphere", x = -48.601578, y = 50.401669, z = -119.496727, radius = 0.5 },
			{ name = "New Collision6", material = "Inherit", type = "sphere", x = 48.612221, y = 50.401493, z = -119.496536, radius = 0.5 },
			{ name = "New Collision7", material = "Inherit", type = "box", x = 107.248215, y = 43.631916, z = 41.87146, width = 105.743439, height = 3.326583, length = 2.322822, rot_x = -0.002261, rot_y = 0.048443, rot_z = 0.046576, rot_w = 0.997737 },
			{ name = "New Collision8", material = "Inherit", type = "box", x = -110.660622, y = 43.991531, z = 41.516483, width = 101.226601, height = 3.943683, length = 3.23563, rot_x = -0.001567, rot_y = -0.038908, rot_z = -0.040217, rot_w = 0.998432 },
			{ name = "New Collision9", material = "Inherit", type = "box", x = 49.229588, y = 21.252113, z = 56.166321, width = 5.514889, height = 2.050576, length = 31.269581, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision10", material = "Inherit", type = "box", x = -49.711235, y = 21.311356, z = 56.160248, width = 5.3256, height = 2.249048, length = 31.373133, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision11", material = "Inherit", type = "box", x = 0.0, y = 45.897602, z = -101.844948, width = 130.729767, height = 3.419477, length = 23.860189, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision12", material = "Inherit", type = "box", x = 48.831001, y = 34.381752, z = -45.126011, width = 2.992954, height = 2.93003, length = 122.584419, rot_x = 0.096325, rot_y = 0.0, rot_z = 0.0, rot_w = 0.99535 },
			{ name = "New Collision13", material = "Inherit", type = "box", x = -48.82745, y = 34.381733, z = -45.269302, width = 3.155658, height = 2.502852, length = 123.566658, rot_x = 0.102364, rot_y = 0.0, rot_z = 0.0, rot_w = 0.994747 },
		},

	},

	airfoils = 
	{

		{
			name = "main wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 12.063268, y = 35.785629, z = 50.75008 },
				Length = 1.5,
				Root_chord = 0.57,
				Tip_chord = 0.175,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 4.7,
				Sweep = 5.2,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 92.695488, y = 42.400036, z = 19.299982 },
					tip_pivot = { x = 148.971115, y = 47.187244, z = 24.270168 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.568,
						Tip_distance = 0.12,
						Root_chord = 0.117,
						Tip_chord = 0.066,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"left_aileron",
						},

						{

							"right_aileron",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "stabiliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.0, y = 45.89687, z = -89.908325 },
				Length = 0.66,
				Root_chord = 0.23,
				Tip_chord = 0.23,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 0.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = -0.021892, y = 45.939472, z = -102.992546 },
					tip_pivot = { x = 45.407139, y = 45.875298, z = -102.890266 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.455,
						Tip_distance = 0.205,
						Root_chord = 0.1,
						Tip_chord = 0.1,
						Min_travel = 30.0,
						Max_travel = 30.0,
					},

					sides =
					{
						{

							"elevator",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "left fine",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 48.602703, y = 32.17804, z = -90.714478 },
				Length = 0.41,
				Root_chord = 0.29,
				Tip_chord = 0.29,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 0.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 48.646034, y = 32.686569, z = -107.405327 },
					tip_pivot = { x = 48.617908, y = 72.524422, z = -106.075974 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.41,
						Tip_distance = 0.0,
						Root_chord = 0.125,
						Tip_chord = 0.136,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"left_rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "rigth fine",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = -48.561794, y = 32.07708, z = -90.62825 },
				Length = 0.41,
				Root_chord = 0.29,
				Tip_chord = 0.29,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 0.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = -48.600559, y = 32.265564, z = -107.317841 },
					tip_pivot = { x = -48.528744, y = 72.872696, z = -106.052353 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.41,
						Tip_distance = 0.0,
						Root_chord = 0.125,
						Tip_chord = 0.136,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"right_rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "left Propeller",
			type = "propeller",
			pivot = { x = 48.624878, y = 36.035915, z = 82.032784 },
			angle = 79.543182,
			spinDirection = 1,
			pusher = 0,
			folding = 0,
			blurRadius = 35.488453,
			blurTexture = "None",

			attributes =
			{
				Position = { x = 48.624878, y = 36.035915, z = 82.032784 },
				Diameter = 0.72,
				Pitch = 0.1,
				Blade_count = 3,
				Idle_RPM = 500,
				Max_RPM = 20000,
				Throttle_Curve = 1.0,
				Down_thrust = 0.0,
				Right_thrust = 0.0,
				Torque = 100.0,
				Response = { load = 1.0, unload = 1.0 },
				Engine = "YS 110",
				Volume_Tuning = 150.0,
				Pitch_Tuning = 10.0,
			},

			spinGeometry = 
			{

				"left_cone_propeller",
			},

			blurGeometry = 
			{

				"left_propeller",
			},

			exhaust = 
			{

				{
					name = "left Exhaust",
					position = { x = 45.490993, y = 46.467838, z = -2.849004 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 1,
						Engine_Smoke_Intensity = 50.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "right Propeller",
			type = "propeller",
			pivot = { x = -48.711552, y = 36.030556, z = 82.012627 },
			angle = 12.820145,
			spinDirection = 1,
			pusher = 0,
			folding = 0,
			blurRadius = 35.389179,
			blurTexture = "None",

			attributes =
			{
				Position = { x = -48.711552, y = 36.030556, z = 82.012627 },
				Diameter = 0.72,
				Pitch = 0.1,
				Blade_count = 3,
				Idle_RPM = 500,
				Max_RPM = 20000,
				Throttle_Curve = 1.0,
				Down_thrust = 0.0,
				Right_thrust = 0.0,
				Torque = 100.0,
				Response = { load = 1.0, unload = 1.0 },
				Engine = "YS 110",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 20.0,
			},

			spinGeometry = 
			{

				"right_cone_propeller",
			},

			blurGeometry = 
			{

				"right_propeller",
			},

			exhaust = 
			{

				{
					name = "right Exhaust",
					position = { x = -51.689011, y = 46.467865, z = -2.442006 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 1,
						Engine_Smoke_Intensity = 50.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "front Gear",
			root_pivot = { x = 2.075786, y = 27.494234, z = 81.759789 },
			tip_pivot = { x = -2.19874, y = 27.494234, z = 81.78952 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 2000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = -110.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"front_gear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "front Wheel",
					pivot = { x = 0.0, y = 6.409241, z = 85.68882 },
					axis = { x = 1.0, y = -0.0, z = 0.0 },
					width = 4.827098,
					radius = 6.567721,

					sides =
					{
						{

							"front_wheel",
						},

					},

				},

			},

		},

		{
			name = "rear Gear",
			root_pivot = { x = 49.66861, y = 31.816256, z = 27.411419 },
			tip_pivot = { x = 43.170563, y = 31.832426, z = 27.416986 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 2000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = -94.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"left_rear_gear",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"right_rear_gear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "rearWheel",
					pivot = { x = 50.589127, y = 9.221237, z = 24.609726 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 4.849646,
					radius = 8.963965,

					sides =
					{
						{

							"left_rear_wheel",
						},

						{

							"right_rear_wheel",
						},

					},

				},

			},

		},

	},

	widgets = 
	{

		{
			name = "front trap",
			root_pivot = { x = -2.868269, y = 21.321741, z = 37.693672 },
			tip_pivot = { x = -2.868269, y = 21.321741, z = 83.721123 },
			mirrored = 0,
			changeTime = 2000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 94.0 },

			sides =
			{
				{

					geometry = 
					{

						"front_trap",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "rear trap 2",
			root_pivot = { x = 55.158596, y = 35.149113, z = -20.726076 },
			tip_pivot = { x = 56.078823, y = 26.117527, z = 33.12915 },
			mirrored = 1,
			changeTime = 2000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = -63.0 },

			sides =
			{
				{

					geometry = 
					{

						"left_rear_trap2",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"right_rear_trap2",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "rear trap1",
			root_pivot = { x = 42.284367, y = 35.46542, z = -20.661409 },
			tip_pivot = { x = 41.159748, y = 25.959177, z = 33.192589 },
			mirrored = 1,
			changeTime = 2000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 63.0 },

			sides =
			{
				{

					geometry = 
					{

						"left_rear_trap1",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"right_rear_trap1",
					},

					collision = 
					{

					},

				},

			},

		},

	},

}