modelTypes.Ju_87 = 
{

	-- header

	name = "Junkers Ju 87 (Stuka)",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "Piewacket",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "Glow Powered Scale Model",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Scale",
	power = "Glow",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 90,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.524,
			Weight = 4.0,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 28.089457, z = 26.104042 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.04, lateral = 0.35, vertical = 0.35 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "WW2_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 5.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Wood",

		geometry = 
		{

			"Fuselarge",
			"FuselargeBits",
			"Canopy Glass",
		},

		collision = 
		{

			{ name = "Fuselarge_Collision", material = "Inherit", type = "mesh", node = "Fuselarge", x = 0.0, y = -0.000004, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
		},

	},

	pilots = 
	{

		{
			name = "Fritz",
			position = { x = 0.0, y = 31.01029, z = 25.868368 },
			size = 0.45,


			attributes =
			{
				Type = "Veteran",
			},

		},

		{
			name = "Wolfgang",
			position = { x = 0.0, y = 31.10508, z = 13.99449 },
			size = 0.45,


			attributes =
			{
				Type = "Veteran",
			},

		},

	},

	airfoils = 
	{

		{
			name = "Main Wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 4.55216, y = 19.475981, z = 38.977764 },
				Length = 0.982579,
				Root_chord = 0.501316,
				Tip_chord = 0.125329,
				Airfoil = "Funfly",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 8.0,
				Sweep = 2.8,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Left_Wing",
						"Left_Wing_Gun",
					},

					collision = 
					{

						{ name = "Left_Wing_Collision", material = "Inherit", type = "mesh", node = "Left_Wing", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
						{ name = "Left_Wing_Gun_Collision", material = "Inherit", type = "mesh", node = "Left_Wing_Gun", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

						"Right_Wing",
						"Right_Wing_Gun",
					},

					collision = 
					{

						{ name = "Right_Wing_Collsion", material = "Inherit", type = "mesh", node = "Right_Wing", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
						{ name = "Right_Wing_Gun_Collision", material = "Inherit", type = "mesh", node = "Right_Wing_Gun", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Aileron",
					root_pivot = { x = 40.303963, y = 23.784306, z = 20.981447 },
					tip_pivot = { x = 65.810616, y = 27.746782, z = 29.790466 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.39604,
						Tip_distance = 0.035092,
						Root_chord = 0.045118,
						Tip_chord = 0.045118,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"Left_Aileron",
						},

						{

							"Right_Wing_Aileron",
						},

					},

				},

			},

			flaps = {

				{
					name = "Outer Flaps",
					root_pivot = { x = 14.270763, y = 20.140333, z = 14.830986 },
					tip_pivot = { x = 39.948231, y = 23.674997, z = 21.127813 },
					is_leading_edge = 0,

					attributes =
					{
						Length = 0.4,
						Root_Chord = 0.079,
						Tip_Chord = 0.045,
						Tip_distance = 0.435,
						Travel = -40.0,
						Lift_increase = 25.0,
						Drag_increase = 25.0,
					},

					sides =
					{
						{

							"Left_Outer_Flap",
						},

						{

							"Right_Wing_Outer_Flap",
						},

					},

				},

				{
					name = "Inner Flaps",
					root_pivot = { x = 4.557608, y = 22.170509, z = 10.795256 },
					tip_pivot = { x = 13.984118, y = 20.803659, z = 14.72546 },
					is_leading_edge = 0,

					attributes =
					{
						Length = 0.149,
						Root_Chord = 0.069,
						Tip_Chord = 0.082,
						Tip_distance = 0.835,
						Travel = -40.0,
						Lift_increase = 25.0,
						Drag_increase = 25.0,
					},

					sides =
					{
						{

							"Left_Inner_Flap",
						},

						{

							"Right_Wing_Inner_Flap",
						},

					},

				},

			},

			airbrakes = {

			},

		},

		{
			name = "Stabalizer",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 1.033984, y = 31.752865, z = -27.309355 },
				Length = 0.365961,
				Root_chord = 0.161925,
				Tip_chord = 0.161925,
				Airfoil = "Funfly",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 0.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Left_Stabaliser",
					},

					collision = 
					{

						"Left_Stabaliser",
					},

				},

				{

					geometry = 
					{

						"Right_Stabaliser",
					},

					collision = 
					{

						"Right_Stabaliser",
					},

				},

			},

			controlSurfaces = {

				{
					name = "Elevator",
					root_pivot = { x = -25.008642, y = 31.776876, z = -32.495266 },
					tip_pivot = { x = 24.77961, y = 31.792873, z = -32.406849 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.368467,
						Tip_distance = 0.0,
						Root_chord = 0.085224,
						Tip_chord = 0.085224,
						Min_travel = 10.0,
						Max_travel = 10.0,
					},

					sides =
					{
						{

							"Left_Elevator",
						},

						{

							"Right_Elevator",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.043092, y = 23.588528, z = -20.396885 },
				Length = 0.360947,
				Root_chord = 0.375987,
				Tip_chord = 0.1905,
				Airfoil = "Funfly",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 25.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = 0.050451, y = 23.78249, z = -37.040157 },
					tip_pivot = { x = -0.026654, y = 45.03339, z = -36.475071 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.360947,
						Tip_distance = 0.0,
						Root_chord = 0.125329,
						Tip_chord = 0.100263,
						Min_travel = 12.0,
						Max_travel = 12.0,
					},

					sides =
					{
						{

							"Rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "Prop",
			type = "propeller",
			pivot = { x = 0.0, y = 27.03019, z = 60.879807 },
			angle = 82.205177,
			spinDirection = 1,
			pusher = 0,
			folding = 0,
			blurRadius = 18.302879,
			blurTexture = "None",

			attributes =
			{
				Position = { x = 0.0, y = 27.03019, z = 60.879807 },
				Diameter = 0.551447,
				Pitch = 0.100263,
				Blade_count = 3,
				Idle_RPM = 1100,
				Max_RPM = 12000,
				Down_thrust = 0.0,
				Right_thrust = 0.0,
				Torque = 100.0,
				Response = { load = 1.0, unload = 1.0 },
				Engine = "YS 110",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			spinGeometry = 
			{

				"Spinner",
			},

			blurGeometry = 
			{

				"Blades",
			},

			exhaust = 
			{

				{
					name = "Right Exhaust",
					position = { x = -5.520127, y = 26.308931, z = 48.461231 },
					vector = { x = -0.653329, y = 0.024707, z = -0.75667 },

					attributes =
					{
						Engine_Smoke = 1,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

				{
					name = "Left Exhaust",
					position = { x = 5.530954, y = 26.002016, z = 48.691013 },
					vector = { x = 0.556769, y = 0.0207, z = -0.830409 },

					attributes =
					{
						Engine_Smoke = 1,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "Main UC",
			root_pivot = { x = 14.847012, y = 19.045633, z = 17.906019 },
			tip_pivot = { x = 14.82253, y = 19.063314, z = 43.358067 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 0,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Left_UC",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"Right_UC",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "Main Wheels",
					pivot = { x = 14.947347, y = 7.211454, z = 35.733757 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 2.567128,
					radius = 4.807734,

					sides =
					{
						{

							"Left_Wheel",
						},

						{

							"Right_Wheel",
						},

					},

				},

			},

		},

		{
			name = "Tail UC",
			root_pivot = { x = -2.211214, y = 23.350138, z = -32.469524 },
			tip_pivot = { x = 2.317575, y = 23.375998, z = -32.463047 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 0,
			isRetractable = 0,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Tail_UC",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "Tail Wheel",
					pivot = { x = 0.052062, y = 20.263361, z = -35.184303 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 0.967339,
					radius = 1.502397,

					sides =
					{
						{

							"Tail_Wheel",
						},

					},

				},

			},

		},

	},

	{
		name = "Airbrake",
		root_pivot = { x = 17.024767, y = 18.370773, z = 33.184147 },
		tip_pivot = { x = 37.742893, y = 22.035246, z = 33.204945 },
		mirrored = 1,
		idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
		full = { x = 0.0, y = 0.0, z = 0.0, angle = 90.0 },

		attributes =
		{
			Drag_Increase = 25.0,
			Lift_Reduction = 25.0,
		},

		sides =
		{
			{

					"Left_Airbreak",
			},

			{

					"Right_Wing_Airbrake",
			},

		},

	},

}