modelTypes.Great_Lakes_Bi_Plane = 
{

	-- header

	name = "Great Lakes Bi-Plane",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "Piewacket",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "Scale Electric",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Scale",
	power = "Electric",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 64,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.5,
			Weight = 2.72,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 19.037149, z = 5.794794 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "WW2_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 120.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 15.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 13.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Wood",

		geometry = 
		{

			"Engine",
			"Engine2",
			"WindshieldGlass",
			"Fuselage2",
			"Fuselage3",
			"EngCowling2",
			"EngCowling1",
			"Fuselage4",
			"CockpitTrim",
			"WindshieldFrame",
			"RAileronPushrod",
			"LAileronPushrod",
			"WingStruts",
			"SpanWires",
			"GearBrace",
			"EngCowling",
			"EngineRods",
			"EngCowling3",
			"PropCone2",
		},

		collision = 
		{

			{ name = "Fuselage", material = "Inherit", type = "mesh", node = "Fuselage3", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "EngCowling4", material = "Inherit", type = "mesh", node = "EngCowling3", x = 0.0, y = -0.000002, z = -0.000004, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
		},

	},

	airfoils = 
	{

		{
			name = "Bottom Wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 5.517184, y = 15.267699, z = 7.852835 },
				Length = 0.735,
				Root_chord = 0.252,
				Tip_chord = 0.252,
				Airfoil = "Trainer Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 2.0,
				Sweep = 0.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Bottom Wing Left",
					},

					collision = 
					{

						{ name = "Bottom Wing Left Collision", material = "Inherit", type = "mesh", node = "Bottom Wing Left", x = 0.0, y = -0.000002, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

						"Bottom Wing Left",
					},

					collision = 
					{

						{ name = "Bottom Wing Right Collision", material = "Inherit", type = "mesh", node = "Bottom Wing Left", x = 0.0, y = -0.000002, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Bottom Ailerons",
					root_pivot = { x = 18.050793, y = 15.815361, z = -4.185742 },
					tip_pivot = { x = 46.907307, y = 16.762394, z = -4.20516 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.435,
						Tip_distance = 0.1125,
						Root_chord = 0.075,
						Tip_chord = 0.075,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"LBotAileron",
						},

						{

							"RBotAileron",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Top Wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.0, y = 36.365902, z = 19.696808 },
				Length = 0.93,
				Root_chord = 0.2775,
				Tip_chord = 0.2775,
				Airfoil = "Trainer Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 1.5,
				Sweep = 9.5,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"TopWing",
					},

					collision = 
					{

						{ name = "TopWing Left Collision", material = "Inherit", type = "mesh", node = "TopWing", x = 0.0, y = -0.000004, z = -0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

						"TopWing",
					},

					collision = 
					{

						{ name = "TopWing Collision", material = "Inherit", type = "mesh", node = "TopWing", x = 0.0, y = -0.000004, z = -0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Top Ailerons",
					root_pivot = { x = 28.373686, y = 36.638126, z = 1.216665 },
					tip_pivot = { x = 51.455143, y = 37.103336, z = -2.694044 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.3495,
						Tip_distance = 0.15,
						Root_chord = 0.075,
						Tip_chord = 0.075,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"L_TopAileron",
						},

						{

							"R_TopAileron",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Stabaliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.0, y = 24.334425, z = -32.040009 },
				Length = 0.3495,
				Root_chord = 0.3,
				Tip_chord = 0.15,
				Airfoil = "Trainer Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 20.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"TailHoriz",
					},

					collision = 
					{

						{ name = "TailHoriz3", material = "Inherit", type = "mesh", node = "TailHoriz", x = 0.0, y = 0.0, z = 0.000008, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

						"TailHoriz",
					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Elevator",
					root_pivot = { x = 21.325958, y = 24.291649, z = -43.49654 },
					tip_pivot = { x = -21.494982, y = 24.223253, z = -43.477551 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.3495,
						Tip_distance = 0.0,
						Root_chord = 0.1275,
						Tip_chord = 0.0975,
						Min_travel = 10.0,
						Max_travel = 10.0,
					},

					sides =
					{
						{

							"Elevator",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.0, y = 19.40517, z = -29.597473 },
				Length = 0.318,
				Root_chord = 0.345,
				Tip_chord = 0.165,
				Airfoil = "Trainer Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 30.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = -0.017167, y = 19.346457, z = -44.453388 },
					tip_pivot = { x = -0.004943, y = 37.729977, z = -44.216957 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.318,
						Tip_distance = 0.0,
						Root_chord = 0.123,
						Tip_chord = 0.105,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"Rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	gear = 
	{

		{
			name = "Front Gear",
			root_pivot = { x = 7.367304, y = 16.097403, z = 3.454501 },
			tip_pivot = { x = 2.724553, y = 16.113708, z = 20.644617 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 1,
			isRetractable = 0,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 15.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"LGearBkt",
						"LGearStrut",
						"LGear",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"RGearBkt",
						"RGearStrut",
						"RGear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "Front Wheels",
					pivot = { x = 11.605433, y = 4.519507, z = 12.047332 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 2.408119,
					radius = 3.749738,

					sides =
					{
						{

							"LWheel",
							"LWheelAxle",
						},

						{

							"RWheel",
							"RWheelAxle",
						},

					},

				},

			},

		},

		{
			name = "Tail Gear",
			root_pivot = { x = -0.018431, y = 21.226612, z = -51.604679 },
			tip_pivot = { x = -0.031152, y = 21.226652, z = -45.443672 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 0,
			isRetractable = 0,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"TailBkt3",
						"TailWheelSpring",
						"TailBkt2",
						"TailBkt1",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "Tail Wheel",
					pivot = { x = 0.0, y = 15.858532, z = -50.246361 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 0.496127,
					radius = 1.713323,

					sides =
					{
						{

							"TWheel",
						},

					},

				},

			},

		},

	},

	propulsion = 
	{

		{
			name = "Propeller",
			type = "propeller",
			pivot = { x = 0.0, y = 21.526306, z = 28.118885 },
			angle = 29.28446,
			spinDirection = 1,
			pusher = 0,
			folding = 0,
			blurRadius = 13.069363,
			blurTexture = "None",

			attributes =
			{
				Position = { x = 0.0, y = 21.526306, z = 28.118885 },
				Diameter = 0.39,
				Pitch = 0.100263,
				Blade_count = 2,
				Idle_RPM = 0,
				Max_RPM = 10000,
				Down_thrust = 0.0,
				Right_thrust = 0.0,
				Torque = 100.0,
				Response = { load = 1.0, unload = 1.0 },
				Engine = "Medium electric",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			spinGeometry = 
			{

				"PropCone",
			},

			blurGeometry = 
			{

				"Prop",
			},

			exhaust = 
			{

			},

		},

	},

	pilots = 
	{

		{
			name = "Biggles",
			position = { x = 0.0, y = 26.091682, z = 2.389817 },
			size = 0.7,


			attributes =
			{
				Type = "Veteran",
			},

		},

		{
			name = "Prince",
			position = { x = 0.0, y = 25.852482, z = -7.419899 },
			size = 0.7,


			attributes =
			{
				Type = "Veteran",
			},

		},

	},

}