modelTypes.Graupner_Yak55 = 
{

	-- header

	name = "Yak 55M",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "Graupner",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "Gernot Bruckmann's indoor F3P/3D shock flyer",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Electric",
	style = "Indoor",
	power = "Electric",
	level = "Advanced",

	supportsTrainingGear = 0,


	nodeCount = 63,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 0.9,
			Weight = 0.17,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 17.542627, z = -2.281708 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.02, lateral = 0.08, vertical = 0.12 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "None",
		},

		Fine_tuning =
		{
			Thrust = 75.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 450.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 100.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 60.0,
				Expo = 35.0,
				Expo_Low_Rate = 20.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 70.0,
				Expo = 30.0,
				Expo_Low_Rate = 15.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 60.0,
				Expo = 35.0,
				Expo_Low_Rate = 20.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Foam",

		geometry = 
		{

			"Mesh23_carbon_L1_Model",
			"Mesh40_Servo3_Model",
			"Mesh25_carbon_L1_Model",
			"Mesh20_carbon_L1_Model",
			"Mesh31_Carbon_R1_Model",
			"Mesh24_carbon_L1_Model",
			"Mesh29_Carbon_R1_Model",
			"Mesh27_carbon_L1_Model",
			"Mesh30_Carbon_R1_Model",
			"Mesh33_Carbon_R1_Model",
			"Mesh21_carbon_L1_Model",
			"Mesh22_carbon_L1_Model",
			"Mesh37_Carbon_R1_Model",
			"Mesh18_Motor_stand1_Model",
			"Mesh2_Fuselage_top1_Model",
			"Mesh3_Fuselage_side1_Model",
			"Mesh42_Stator1_Model",
			"Mesh34_Carbon_R1_Model",
			"Mesh41_Servo4_Model",
			"Mesh35_Carbon_R1_Model",
		},

		collision = 
		{

			{ name = "Fuselage Collision", material = "Inherit", type = "box", x = 0.0, y = 21.607111, z = -22.27516, width = 16.762314, height = 30.978113, length = 93.843765, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
		},

	},

	airfoils = 
	{

		{
			name = "Main Wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.0, y = 17.537254, z = 9.323547 },
				Length = 0.45,
				Root_chord = 0.263,
				Tip_chord = 0.129,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 6.8,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Mesh8_Wing_L1_Model",
						"Mesh26_carbon_L1_Model",
						"Mesh39_Servo2_Model",
						"Mesh28_carbon_L1_Model",
					},

					collision = 
					{

						{ name = "Wing L Collision", material = "Inherit", type = "box", x = 28.095482, y = 17.539551, z = -4.766331, width = 43.62484, height = 0.333105, length = 27.96455, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

						"Mesh32_Carbon_R1_Model",
						"Mesh36_Carbon_R1_Model",
						"Mesh7_Wing_R1_Model",
						"Mesh38_Servo1_Model",
					},

					collision = 
					{

						{ name = "Wing R Collision", material = "Inherit", type = "box", x = -28.095482, y = 17.539551, z = -4.766331, width = 43.62484, height = 0.333105, length = 27.964556, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Aileron",
					root_pivot = { x = 6.578319, y = 17.533701, z = -5.857181 },
					tip_pivot = { x = 48.910896, y = 17.537769, z = -1.557108 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.395,
						Tip_distance = 0.0,
						Root_chord = 0.116,
						Tip_chord = 0.085,
						Min_travel = 35.0,
						Max_travel = 35.0,
					},

					sides =
					{
						{

							"Mesh5_Aileron_L1_Model",
						},

						{

							"Mesh6_Aileron_R1_Model",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Stabilizer",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.0, y = 17.534233, z = -53.605663 },
				Length = 0.199,
				Root_chord = 0.157,
				Tip_chord = 0.1,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 7.9,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = -0.8, max = -0.8 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

						{ name = "Elevator Collision", material = "Inherit", type = "box", x = -0.00835, y = 17.53956, z = -62.661148, width = 43.7831, height = 0.333103, length = 18.039145, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Elevator",
					root_pivot = { x = 1.341933, y = 17.534712, z = -59.885696 },
					tip_pivot = { x = 21.124344, y = 17.540663, z = -59.907085 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.19,
						Tip_distance = 0.0,
						Root_chord = 0.099,
						Tip_chord = 0.0706,
						Min_travel = 50.0,
						Max_travel = 50.0,
					},

					sides =
					{
						{

							"Mesh4_Elevator1_Model",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.0, y = 10.00676, z = -49.622887 },
				Length = 0.271,
				Root_chord = 0.307,
				Tip_chord = 0.106,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 27.700001,
				Robustness = 150.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

						{ name = "Rudder Collision", material = "Inherit", type = "box", x = 0.0, y = 21.880707, z = -70.812096, width = 0.3331, height = 29.518412, length = 22.297604, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = -0.006366, y = 10.448956, z = -64.958488 },
					tip_pivot = { x = -0.007363, y = 34.060982, z = -64.954193 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.271,
						Tip_distance = 0.0,
						Root_chord = 0.169,
						Tip_chord = 0.094,
						Min_travel = 35.0,
						Max_travel = 35.0,
					},

					sides =
					{
						{

							"Mesh9_Rudder1_Model",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "Propeller",
			type = "propeller",
			pivot = { x = 0.0, y = 17.534052, z = 24.429316 },
			angle = -64.013763,
			spinDirection = 1,
			pusher = 0,
			folding = 0,
			blurRadius = 13.004498,
			blurTexture = "None",

			attributes =
			{
				Position = { x = 0.0, y = 17.534052, z = 24.429316 },
				Diameter = 0.23,
				Pitch = 0.1,
				Blade_count = 2,
				Idle_RPM = 0,
				Max_RPM = 7300,
				Down_thrust = 0.0,
				Right_thrust = 0.0,
				Torque = 100.0,
				Response = { load = 3.0, unload = 3.0 },
				Engine = "Light electric",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			spinGeometry = 
			{

				"Mesh19_Motor_bell1_Model",
			},

			blurGeometry = 
			{

				"Mesh1_Group2_Model",
			},

			exhaust = 
			{

			},

		},

	},

	gear = 
	{

		{
			name = "Landing Gear",
			root_pivot = { x = 0.481785, y = 12.834748, z = 1.365271 },
			tip_pivot = { x = 0.481786, y = 12.834748, z = 10.795486 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 0,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 50.0,
				Stiffness = 50.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Mesh15_LG_carbon2_Model",
						"Mesh16_LG2_Model",
						"Mesh14_Wheel_cover2_Model",
					},

					collision = 
					{

						{ name = "Gear L Collision", material = "Inherit", type = "box", x = 6.42852, y = 6.361275, z = 4.862303, width = 13.082278, height = 13.417024, length = 12.484493, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

						"Mesh13_LG_carbon1_Model",
						"Mesh10_LG1_Model",
						"Mesh11_Wheel_cover1_Model",
					},

					collision = 
					{

						{ name = "Gear R Collision", material = "Inherit", type = "box", x = -6.42852, y = 6.361275, z = 4.862303, width = 13.082278, height = 13.417024, length = 12.484493, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			wheels = 
			{

				{
					name = "Wheels",
					pivot = { x = 11.430018, y = 1.499878, z = 6.292306 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 0.518822,
					radius = 1.510269,

					sides =
					{
						{

							"Mesh17_Wheel2_Model",
						},

						{

							"Mesh12_Wheel1_Model",
						},

					},

				},

			},

		},

	},

}