modelTypes.F_5E_turbine = 
{

	-- header

	name = "F-5E turbine ",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Park-flier",
	power = "Turbine",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 57,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.0,
			Weight = 3.5,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 27.642393, z = -10.052148 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "None",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 300.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 30.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Plastic",

		geometry = 
		{

			"default",
			"LOD0",
			"default2",
			"Canopy01",
			"default3",
			"Glass_Canopy01",
			"default4",
			"Eject_Seat01",
			"default5",
			"Pilot01",
			"default6",
			"EngineL01",
			"default7",
			"EngineR01",
			"default8",
			"Glass_HUD",
			"default9",
			"Glass01",
			"default10",
			"default11",
			"default12",
			"default13",
			"FlapL01",
			"default14",
			"FlapR01",
			"default15",
			"default16",
			"VoletL01",
			"default17",
			"VoletR01",
			"default18",
			"default19",
			"default20",
			"default21",
			"default22",
			"default23",
			"default24",
			"default25",
			"default26",
			"default27",
			"default28",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "sphere", x = -0.006051, y = 21.377518, z = 130.476685, radius = 2.769318 },
			{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.004786, y = 23.343296, z = 103.201836, radius = 5.804046 },
			{ name = "New Collision3", material = "Inherit", type = "sphere", x = -0.002963, y = 26.291946, z = 63.886959, radius = 10.827813 },
			{ name = "New Collision4", material = "Inherit", type = "sphere", x = -0.00196, y = 44.966621, z = 42.263676, radius = 2.422165 },
			{ name = "New Collision5", material = "Inherit", type = "sphere", x = -0.000866, y = 47.915207, z = 18.674654, radius = 2.913609 },
			{ name = "New Collision6", material = "Inherit", type = "sphere", x = 0.006705, y = 28.839849, z = -144.580261, radius = 5.527461 },
			{ name = "New Collision7", material = "Inherit", type = "box", x = 44.294014, y = 24.503092, z = -32.171421, width = 67.10569, height = 3.601988, length = 10.019215, rot_x = 0.0, rot_y = 0.253136, rot_z = 0.0, rot_w = 0.967431 },
			{ name = "New Collision8", material = "Inherit", type = "box", x = -44.760014, y = 24.503181, z = -31.471916, width = 67.932129, height = 3.425016, length = 9.382118, rot_x = 0.000647, rot_y = -0.26027, rot_z = 0.002399, rot_w = 0.965533 },
			{ name = "New Collision9", material = "Inherit", type = "sphere", x = -76.232079, y = 24.755781, z = -27.061378, radius = 4.663762 },
			{ name = "New Collision10", material = "Inherit", type = "sphere", x = 76.465042, y = 24.682741, z = -27.042505, radius = 4.677114 },
			{ name = "New Collision11", material = "Inherit", type = "box", x = 27.975077, y = 26.117962, z = -103.740913, width = 35.691685, height = 2.448531, length = 6.032783, rot_x = 0.0, rot_y = 0.280242, rot_z = 0.0, rot_w = 0.959929 },
			{ name = "New Collision12", material = "Inherit", type = "box", x = -28.208305, y = 26.088335, z = -102.808266, width = 33.551666, height = 2.412793, length = 6.360134, rot_x = 0.0, rot_y = -0.289227, rot_z = 0.0, rot_w = 0.95726 },
			{ name = "New Collision13", material = "Inherit", type = "box", x = 0.004245, y = 61.248154, z = -91.536888, width = 3.468334, height = 3.468334, length = 51.619209, rot_x = 0.447642, rot_y = 0.0, rot_z = 0.0, rot_w = 0.894213 },
			{ name = "New Collision14", material = "Inherit", type = "box", x = 0.0, y = 21.075893, z = -48.541092, width = 18.831308, height = 2.374118, length = 149.762695, rot_x = 0.014381, rot_y = 0.0, rot_z = 0.0, rot_w = 0.999897 },
		},

	},

	airfoils = 
	{

		{
			name = "wings Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 13.264335, y = 24.400003, z = -12.158919 },
				Length = 0.725,
				Root_chord = 0.61,
				Tip_chord = 0.175,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 31.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "ailerons Control surface",
					root_pivot = { x = 39.16238, y = 24.556492, z = -56.965157 },
					tip_pivot = { x = 57.322582, y = 24.556162, z = -59.192047 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.21,
						Tip_distance = 0.21,
						Root_chord = 0.135,
						Tip_chord = 0.1,
						Min_travel = 40.0,
						Max_travel = 40.0,
					},

					sides =
					{
						{

							"AileronL01",
						},

						{

							"AileronR01",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "elevators Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 12.358399, y = 25.999987, z = -93.276031 },
				Length = 0.35,
				Root_chord = 0.32,
				Tip_chord = 0.11,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 32.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = " elevators Control surface",
					root_pivot = { x = 12.293921, y = 25.955099, z = -109.878586 },
					tip_pivot = { x = 38.846451, y = 26.048754, z = -110.160637 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.35,
						Tip_distance = 0.0,
						Root_chord = 0.321,
						Tip_chord = 0.11,
						Min_travel = 10.0,
						Max_travel = 10.0,
					},

					sides =
					{
						{

							"ElevatorL01",
							"ElevatorR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "rudder Airfoil",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.003593, y = 39.530766, z = -74.923065 },
				Length = 0.51,
				Root_chord = 0.57,
				Tip_chord = 0.15,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 37.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 0.104906, y = 36.92075, z = -117.699951 },
					tip_pivot = { x = -0.012205, y = 57.086082, z = -117.899918 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.25,
						Tip_distance = 0.2905,
						Root_chord = 0.15,
						Tip_chord = 0.09,
						Min_travel = 40.0,
						Max_travel = 40.0,
					},

					sides =
					{
						{

							"RudderL01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "right Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = -10.028488, y = 27.648851, z = -9.992608 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 60.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "right Exhaust",
					position = { x = -76.16993, y = 24.66128, z = -72.70639 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "leftTurbine",
			type = "turbine",

			attributes =
			{
				Position = { x = 9.841062, y = 27.693731, z = -9.961013 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 60.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "left Exhaust",
					position = { x = 75.703674, y = 24.756405, z = -73.01091 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "front Gear",
			root_pivot = { x = 2.999174, y = 19.775799, z = 64.077843 },
			tip_pivot = { x = -2.838355, y = 19.775799, z = 64.071754 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 0.0, y = 4.0, z = 0.0, angle = 90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"train_d_attrissage:FrontGear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "front Wheel",
					pivot = { x = -0.048192, y = 4.150833, z = 63.11467 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 4.70456,
					radius = 4.010033,

					sides =
					{
						{

							"train_d_attrissage:FrontWheels",
						},

					},

				},

			},

		},

		{
			name = "rear left Gear",
			root_pivot = { x = 31.082508, y = 22.439749, z = -51.731106 },
			tip_pivot = { x = 30.95055, y = 22.439749, z = -46.703583 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = -8.0, y = 1.0, z = 0.0, angle = -90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"train_d_attrissage:verrain_bas_train_d",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "New Wheel",
					pivot = { x = 28.737463, y = 5.46447, z = -49.229843 },
					axis = { x = 1.0, y = 0.0, z = -0.0 },
					width = 3.229424,
					radius = 5.342461,

					sides =
					{
						{

							"train_d_attrissage:RightRearWheel",
						},

					},

				},

			},

		},

		{
			name = "rear right Gear",
			root_pivot = { x = -31.293468, y = 22.750769, z = -50.425449 },
			tip_pivot = { x = -31.293468, y = 22.750769, z = -47.052505 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 6000.0,
			idle = { x = 8.0, y = 1.0, z = 0.0, angle = 90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"train_d_attrissage:verrain_bas_train_g",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "New Wheel2",
					pivot = { x = -28.525257, y = 5.435349, z = -49.257038 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 2.47732,
					radius = 5.385109,

					sides =
					{
						{

							"train_d_attrissage:LeftRearWheel",
						},

					},

				},

			},

		},

		{
			name = "front left trap",
			root_pivot = { x = 3.065437, y = 17.549141, z = 59.134331 },
			tip_pivot = { x = 2.876659, y = 18.024612, z = 84.961441 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"front_left_trap",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "front right trap",
			root_pivot = { x = -2.838218, y = 17.648726, z = 58.662411 },
			tip_pivot = { x = -2.838218, y = 18.012201, z = 84.787041 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 0.0, y = -0.2, z = 0.0, angle = 100.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"front_right_trap",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "rear left trap",
			root_pivot = { x = 32.914341, y = 22.502131, z = -55.848763 },
			tip_pivot = { x = 32.914341, y = 22.502131, z = -44.91468 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -91.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"rear_left_trap",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "rear right trap",
			root_pivot = { x = -32.892792, y = 22.262819, z = -52.459045 },
			tip_pivot = { x = -32.892792, y = 22.262819, z = -37.459045 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 6000.0,
			idle = { x = 0.6, y = 0.5, z = -0.2, angle = 92.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"rear_right_trap",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

	},

}