modelTypes.F_15C_Eagle_Turbine = 
{

	-- header

	name = "F-15C_Eagle Turbine",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Park-flier",
	power = "Turbine",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 92,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.0,
			Weight = 4.0,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 20.036526, z = 20.036484 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "None",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Plastic",

		geometry = 
		{

			"default",
			"default2",
			"default3",
			"default4",
			"default5",
			"default6",
			"default7",
			"default8",
			"default9",
			"default10",
			"default11",
			"default12",
			"default13",
			"default14",
			"default15",
			"default16",
			"default17",
			"F_15C_Eagle:IntakeR01",
			"default18",
			"F_15C_Eagle:IntakeL01",
			"default19",
			"default20",
			"F_15C_Eagle:FlapR01",
			"default21",
			"F_15C_Eagle:FlapL01",
			"default22",
			"F_15C_Eagle:BrakeL01",
			"default23",
			"default24",
			"default25",
			"default26",
			"default27",
			"default28",
			"F_15C_Eagle:EngineR01",
			"default29",
			"F_15C_Eagle:EngineL01",
			"default30",
			"F_15C_Eagle:Pilot01",
			"default31",
			"F_15C_Eagle:Eject_Seat01",
			"default32",
			"F_15C_Eagle:Glass_HUD",
			"default33",
			"F_15C_Eagle:Glass01",
			"default34",
			"F_15C_Eagle:Glass_Canopy01",
			"default35",
			"F_15C_Eagle:Canopy01",
			"default36",
			"F_15C_Eagle:LOD0",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "sphere", x = -0.006756, y = 28.560095, z = 145.686005, radius = 1.850488 },
			{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.005884, y = 30.452749, z = 126.886398, radius = 6.756836 },
			{ name = "New Collision3", material = "Inherit", type = "sphere", x = -0.004575, y = 33.092064, z = 98.66713, radius = 11.590221 },
			{ name = "New Collision4", material = "Inherit", type = "sphere", x = -0.003455, y = 54.002892, z = 74.507751, radius = 2.446784 },
			{ name = "New Collision5", material = "Inherit", type = "box", x = 62.955132, y = 34.699013, z = -30.134743, width = 98.479179, height = 2.952029, length = 8.464621, rot_x = -0.005052, rot_y = 0.389853, rot_z = -0.011933, rot_w = 0.920786 },
			{ name = "New Collision6", material = "Inherit", type = "box", x = -62.953022, y = 34.506195, z = -29.537977, width = 100.375854, height = 4.010603, length = 8.534362, rot_x = -0.006065, rot_y = -0.369554, rot_z = 0.015247, rot_w = 0.929064 },
			{ name = "New Collision7", material = "Inherit", type = "box", x = -50.423344, y = 29.084969, z = -120.538933, width = 54.797012, height = 3.19451, length = 9.598441, rot_x = 0.0, rot_y = -0.403865, rot_z = 0.0, rot_w = 0.914819 },
			{ name = "New Collision8", material = "Inherit", type = "box", x = 50.247223, y = 29.348454, z = -119.751717, width = 56.715981, height = 2.824234, length = 9.856865, rot_x = 0.0, rot_y = 0.410289, rot_z = 0.0, rot_w = 0.911956 },
			{ name = "New Collision9", material = "Inherit", type = "box", x = -26.748274, y = 60.25843, z = -106.195107, width = 2.313885, height = 8.8365, length = 55.457958, rot_x = 0.440175, rot_y = 0.0, rot_z = 0.0, rot_w = 0.897912 },
			{ name = "New Collision10", material = "Inherit", type = "box", x = 26.644283, y = 60.258587, z = -106.195549, width = 2.63496, height = 8.728414, length = 55.371132, rot_x = 0.440551, rot_y = 0.0, rot_z = 0.0, rot_w = 0.897728 },
			{ name = "New Collision11", material = "Inherit", type = "sphere", x = 26.523529, y = 84.083443, z = -137.328491, radius = 1.88332 },
			{ name = "New Collision12", material = "Inherit", type = "sphere", x = -26.813637, y = 84.083176, z = -137.54007, radius = 1.782468 },
			{ name = "New Collision13", material = "Inherit", type = "box", x = 0.0, y = 19.74081, z = -47.074268, width = 6.75097, height = 6.75097, length = 101.506317, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
		},

	},

	airfoils = 
	{

		{
			name = "wings Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 29.153017, y = 35.640015, z = 4.287183 },
				Length = 1.0,
				Root_chord = 0.82,
				Tip_chord = 0.27,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = -2.0,
				Sweep = 45.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 60.580746, y = 34.357044, z = -70.529999 },
					tip_pivot = { x = 86.726654, y = 33.644455, z = -81.692337 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.37,
						Tip_distance = 0.185,
						Root_chord = 0.14,
						Tip_chord = 0.09,
						Min_travel = 40.0,
						Max_travel = 40.0,
					},

					sides =
					{
						{

							"F_15C_Eagle:AileronL01",
						},

						{

							"F_15C_Eagle:AileronR01",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "elevator Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 26.86204, y = 29.37359, z = -91.950279 },
				Length = 0.61,
				Root_chord = 0.56,
				Tip_chord = 0.17,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 50.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 26.732698, y = 29.629156, z = -123.14238 },
					tip_pivot = { x = 52.96999, y = 29.374645, z = -123.193642 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.61,
						Tip_distance = 0.0,
						Root_chord = 0.56,
						Tip_chord = 0.17,
						Min_travel = 7.0,
						Max_travel = 7.0,
					},

					sides =
					{
						{

							"F_15C_Eagle:ElevatorL01",
							"F_15C_Eagle:ElevatorR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "left rudder Airfoil",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 26.631609, y = 34.421173, z = -86.284821 },
				Length = 0.6,
				Root_chord = 0.49,
				Tip_chord = 0.16,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 36.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 26.489552, y = 40.798103, z = -121.697769 },
					tip_pivot = { x = 26.578764, y = 78.233803, z = -130.240067 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.465,
						Tip_distance = 0.055,
						Root_chord = 0.14,
						Tip_chord = 0.07,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"F_15C_Eagle:RudderL01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "right rudder Airfoil",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = -26.713833, y = 34.421173, z = -86.284821 },
				Length = 0.6,
				Root_chord = 0.49,
				Tip_chord = 0.16,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 36.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = -26.486704, y = 40.952576, z = -121.497391 },
					tip_pivot = { x = -26.694283, y = 78.486404, z = -130.430984 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.465,
						Tip_distance = 0.055,
						Root_chord = 0.14,
						Tip_chord = 0.07,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"F_15C_Eagle:RudderR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "left Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = 14.375779, y = 29.935766, z = -54.853275 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = -30.0,
				Max_Thrust = 60.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 150.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "left Exhaust",
					position = { x = 11.37477, y = 30.158751, z = -129.438889 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "right Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = -14.327967, y = 30.129625, z = -54.853027 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = -30.0,
				Max_Thrust = 60.0,
				Spool_Time = 5.0,
				Engine = "Turbo-fan",
				Volume_Tuning = 50.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "right Exhaust",
					position = { x = -10.933676, y = 30.158623, z = -128.876541 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "front Gear",
			root_pivot = { x = 2.820888, y = 25.160513, z = 73.622437 },
			tip_pivot = { x = -3.221305, y = 25.160513, z = 73.607819 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 0.0, y = 2.0, z = 0.0, angle = -90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"FrontGear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "New Wheel",
					pivot = { x = -0.003316, y = 5.029144, z = 71.514862 },
					axis = { x = 1.0, y = 0.0, z = -0.0 },
					width = 9.924164,
					radius = 5.145734,

					sides =
					{
						{

							"FrontWheels",
						},

					},

				},

			},

		},

		{
			name = "rear  left Gear",
			root_pivot = { x = 15.172028, y = 22.026756, z = -41.642441 },
			tip_pivot = { x = 15.198479, y = 21.981195, z = -27.822567 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 10.0, y = 8.0, z = 10.0, angle = -120.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"verrain_bas_train_g",
							"verrain_haut_train_g",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "left Wheel",
					pivot = { x = 29.716431, y = 6.865204, z = -51.198021 },
					axis = { x = 1.000002, y = -0.0, z = -0.0 },
					width = 4.298037,
					radius = 7.200208,

					sides =
					{
						{

							"LeftRearWheel",
						},

					},

				},

			},

		},

		{
			name = "supp front Gear",
			root_pivot = { x = 3.511811, y = 27.839203, z = 39.663689 },
			tip_pivot = { x = -3.413182, y = 27.839203, z = 39.698849 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 0.0, y = 4.0, z = -10.0, angle = 25.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"FrontGearRearSupp",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "rear right Gear",
			root_pivot = { x = -15.004593, y = 21.979475, z = -38.529926 },
			tip_pivot = { x = -15.004593, y = 21.97998, z = -31.938789 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = -10.0, y = 8.0, z = 10.0, angle = 120.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"verrain_bas_train_d",
							"verrain_haut_train_d",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "New Wheel2",
					pivot = { x = -29.730667, y = 6.877432, z = -51.18766 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 4.290583,
					radius = 7.206248,

					sides =
					{
						{

							"RightRearWheel",
						},

					},

				},

			},

		},

	},

	widgets = 
	{

		{
			name = "left front trap Widget",
			root_pivot = { x = 6.493782, y = 26.11039, z = 29.244667 },
			tip_pivot = { x = 6.493782, y = 26.11039, z = 77.10704 },
			mirrored = 1,
			changeTime = 4000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -60.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"front_trap_g",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"front_trap_d",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "rear trap 1 Widget",
			root_pivot = { x = 28.786978, y = 33.507557, z = -52.725414 },
			tip_pivot = { x = 28.786978, y = 33.507557, z = -37.725414 },
			mirrored = 1,
			changeTime = 4000.0,
			input = "None",
			idle = { x = 1.9, y = 0.2, z = 0.0, angle = -80.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"ar_g_trap_g",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"ar_d_trap_d",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "rear trap 2 Widget",
			root_pivot = { x = 3.54333, y = 20.73921, z = -52.641258 },
			tip_pivot = { x = 3.54333, y = 20.73921, z = -21.112003 },
			mirrored = 1,
			changeTime = 4000.0,
			input = "None",
			idle = { x = 0.0, y = 0.1, z = 0.0, angle = 45.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"ar_g_trap_d",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"ar_d_trap_g",
					},

					collision = 
					{

					},

				},

			},

		},

	},

}