modelTypes.F_14_tomcat = 
{

	-- header

	name = "F-14 Tomcat",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "Scale ducted-fan jet",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Electric",
	style = "Park-flier",
	power = "Electric",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 96,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 0.9,
			Weight = 2.2,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 13.867826, z = -0.202911 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.029793, lateral = 0.203609, vertical = 0.203609 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Jet_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Foam",

		geometry = 
		{

			"LOD0",
			"EngineR01",
			"EngineL01",
			"Canopy01",
			"Glass_Canopy01",
			"Glass_HUD",
			"Glass01",
			"BrakeL02",
			"BrakeL01",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "sphere", x = -0.003149, y = 10.335326, z = 67.897446, radius = 1.534214 },
			{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.002703, y = 11.196599, z = 58.279884, radius = 3.640703 },
			{ name = "New Collision3", material = "Inherit", type = "sphere", x = -0.001757, y = 21.244835, z = 37.896336, radius = 3.640703 },
			{ name = "New Collision4", material = "Inherit", type = "sphere", x = 11.742096, y = 14.068117, z = 23.728876, radius = 3.640703 },
			{ name = "New Collision5", material = "Inherit", type = "sphere", x = -11.217933, y = 14.068117, z = 23.728876, radius = 3.640703 },
			{ name = "New Collision6", material = "Inherit", type = "sphere", x = 23.893644, y = 9.217023, z = 0.382255, radius = 2.501901 },
			{ name = "New Collision7", material = "Inherit", type = "sphere", x = -23.836411, y = 9.217023, z = 0.382255, radius = 2.501901 },
			{ name = "New Collision8", material = "Inherit", type = "sphere", x = 71.159012, y = 12.626939, z = -32.599895, radius = 4.388114 },
			{ name = "New Collision9", material = "Inherit", type = "sphere", x = -70.983643, y = 12.626957, z = -32.599895, radius = 4.388114 },
			{ name = "New Collision10", material = "Inherit", type = "sphere", x = 0.0, y = 0.0, z = 0.0, radius = 0.5 },
			{ name = "New Collision11", material = "Inherit", type = "sphere", x = 0.003049, y = 8.325669, z = -65.744133, radius = 2.280146 },
			{ name = "New Collision12", material = "Inherit", type = "sphere", x = 12.790586, y = 32.584949, z = -74.069801, radius = 2.280146 },
			{ name = "New Collision13", material = "Inherit", type = "sphere", x = 12.751461, y = 33.159134, z = -63.447422, radius = 2.280146 },
			{ name = "New Collision14", material = "Inherit", type = "sphere", x = 37.03035, y = 10.764352, z = -66.44899, radius = 3.599124 },
			{ name = "New Collision15", material = "Inherit", type = "sphere", x = -36.22084, y = 10.764352, z = -66.44899, radius = 3.599124 },
			{ name = "New Collision16", material = "Inherit", type = "sphere", x = -12.191807, y = 32.584949, z = -74.069801, radius = 2.280146 },
			{ name = "New Collision17", material = "Inherit", type = "sphere", x = -12.191401, y = 33.159134, z = -63.447422, radius = 2.280146 },
		},

	},

	airfoils = 
	{

		{
			name = "Main wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 18.106133, y = 13.599995, z = -6.466499 },
				Length = 0.54,
				Root_chord = 0.252,
				Tip_chord = 0.108,
				Airfoil = "NACA 2314",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 24.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Aileron",
					root_pivot = { x = 40.837479, y = 13.723368, z = -32.088165 },
					tip_pivot = { x = 68.543839, y = 13.663078, z = -36.353394 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.27,
						Tip_distance = 0.045,
						Root_chord = 0.054,
						Tip_chord = 0.054,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Stabiliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 16.93922, y = 10.309956, z = -39.748562 },
				Length = 0.306,
				Root_chord = 0.27,
				Tip_chord = 0.0675,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 53.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Elevator",
					root_pivot = { x = 17.023878, y = 10.328238, z = -61.734474 },
					tip_pivot = { x = 37.333702, y = 10.258204, z = -66.491188 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.306,
						Tip_distance = 0.0,
						Root_chord = 0.072,
						Tip_chord = 0.072,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"ElevatorR01",
							"ElevatorL01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Left fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 11.128257, y = 15.000001, z = -41.982475 },
				Length = 0.261,
				Root_chord = 0.225,
				Tip_chord = 0.09,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 85.0,
				Sweep = 49.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = 11.042892, y = 15.302079, z = -60.157852 },
					tip_pivot = { x = 12.346683, y = 29.397564, z = -68.275505 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.198,
						Tip_distance = 0.063,
						Root_chord = 0.063,
						Tip_chord = 0.036,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"RudderL01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Right fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = -10.506987, y = 15.000001, z = -41.982475 },
				Length = 0.261,
				Root_chord = 0.225,
				Tip_chord = 0.09,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 95.0,
				Sweep = 49.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = -10.340038, y = 15.114635, z = -60.202644 },
					tip_pivot = { x = -11.809542, y = 29.301016, z = -68.364586 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.198,
						Tip_distance = 0.063,
						Root_chord = 0.063,
						Tip_chord = 0.036,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"RudderR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Inner wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 10.46092, y = 13.779376, z = 25.864876 },
				Length = 0.35,
				Root_chord = 0.5,
				Tip_chord = 0.1,
				Airfoil = "NACA 2314",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 70.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "Ducted fan",
			type = "turbine",

			attributes =
			{
				Position = { x = 0.001302, y = 9.511012, z = -28.074684 },
				Idle_RPM = 0.0,
				Max_RPM = 25000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 30.0,
				Spool_Time = 0.5,
				Engine = "Icon A5 electric",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust",
					position = { x = -11.236793, y = 9.416063, z = -63.219242 },
					vector = { x = -0.013791, y = 0.0, z = -0.999905 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

				{
					name = "New Exhaust2",
					position = { x = 12.023621, y = 9.445609, z = -63.219242 },
					vector = { x = -0.013791, y = 0.0, z = -0.999905 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

	},

	pilots = 
	{

		{
			name = "Front pilot",
			position = { x = -0.001486, y = 16.119137, z = 35.680363 },
			size = 0.555752,


			attributes =
			{
				Type = "Fighter_pilot",
			},

		},

		{
			name = "Rear pilot",
			position = { x = -0.001486, y = 16.119137, z = 25.722895 },
			size = 0.555752,


			attributes =
			{
				Type = "Fighter_pilot",
			},

		},

	},

	widgets = 
	{

		{
			name = "New Widget",
			root_pivot = { x = 22.848112, y = 13.770142, z = -9.254096 },
			tip_pivot = { x = 22.848806, y = 34.344353, z = -9.23924 },
			mirrored = 1,
			changeTime = 4000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 22.5 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 40.0 },

			sides =
			{
				{

					geometry = 
					{

						"WingL01",
							"AileronL01",
							"FlapL01",
							"FlapL02",
							"VoletL01",
							"VoletL02",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"WingR01",
							"AileronR01",
							"FlapR01",
							"FlapR02",
							"VoletR01",
							"VoletR02",
					},

					collision = 
					{

					},

				},

			},

		},

	},

}