modelTypes.FT_Sportster_Skinned = 
{

	-- header

	name = "Sportster",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "Flite Test",
	revision = 1.0,
	formatVersion = "5.5.f",
	minProgramVersion = "5.0.a",
	description = "by Richard Kennedy & Jeff Andvik",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Electric",
	style = "Park-flier",
	power = "Electric",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 86,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 100.0,
			Size = 1.0,
			Weight = 0.65,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 23.821682, z = 0.924962 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "None",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = { severity = 100.0, limit = 100.0, speed = 100.0 },
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Torque = 100.0,
			Ground_Torque_Effect = 100.0,
			Rudder_Roll_Coupling = 0.0,
			Rudder_Elevator_Coupling = 0.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 2.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Foam",

		geometry = 
		{

			"Fuselage_Bottom_Plane.015",
			"Firewall.001_Plane.012",
			"PropShaft_Cylinder.005",
			"Motor_Cylinder.004",
			"Wheel.Right_Cylinder.003",
			"Wheel.Left_Cylinder.002",
			"Gear_Cylinder",
			"InteriorBlock_Cube",
			"Plane_Plane.014",
			"Exhaust.Left_Plane.013",
			"Exhaust.Right_Plane.011",
			"CockpitFormer_Plane.010",
			"Windshield_Plane.009",
			"FrontTurtleDeck_Plane.008",
			"RearTurtleDeck_Plane.007",
			"Fuselage_Plane.006",
		},

		collision = 
		{

			{ name = "Fuselage_Bottom_Plane.", material = "Inherit", type = "box", x = 0.017637, y = 21.151754, z = -6.183665, width = 6.637925, height = 14.186019, length = 69.80442, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
		},

	},

	airfoils = 
	{

		{
			name = "Main Wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.0, y = 16.268549, z = 14.000004 },
				Length = 0.5,
				Root_chord = 0.27,
				Tip_chord = 0.27,
				Airfoil = "Funfly",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 3.0,
				Sweep = 0.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Wing.Left_Plane.005",
					},

					collision = 
					{

						{ name = "Wing.Left_Plane.", material = "Inherit", type = "mesh", node = "Wing.Left_Plane.005", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

						"Wing.Right_Plane.002",
					},

					collision = 
					{

						{ name = "Wing.Right_Plane.", material = "Inherit", type = "mesh", node = "Wing.Right_Plane.002", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Ailerons",
					root_pivot = { x = 5.415986, y = 16.579929, z = -6.848659 },
					tip_pivot = { x = 41.824352, y = 18.493177, z = -6.809618 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.345,
						Tip_distance = 0.1,
						Root_chord = 0.06,
						Tip_chord = 0.06,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"Aileron.Left_Plane.004",
						},

						{

							"Aileron.Right_Plane.003",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Stabiliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.0, y = 26.678343, z = -31.200726 },
				Length = 0.24,
				Root_chord = 0.18,
				Tip_chord = 0.11,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 18.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Stabiliser_Cube.003",
					},

					collision = 
					{

						{ name = "Stabiliser_Cube.", material = "Inherit", type = "mesh", node = "Stabiliser_Cube.003", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Elevator",
					root_pivot = { x = -22.801035, y = 26.566206, z = -42.04282 },
					tip_pivot = { x = 22.902349, y = 26.672482, z = -42.04253 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.22,
						Tip_distance = 0.0,
						Root_chord = 0.073,
						Tip_chord = 0.075,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"Elevator_Cube.004",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = -0.000167, y = 19.600004, z = -23.832323 },
				Length = 0.28,
				Root_chord = 0.26,
				Tip_chord = 0.076,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 35.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Fin_Plane",
					},

					collision = 
					{

						{ name = "Fin_Plane2", material = "Inherit", type = "mesh", node = "Fin_Plane", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = 0.019001, y = 19.604265, z = -42.008503 },
					tip_pivot = { x = 0.01962, y = 42.497295, z = -41.989754 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.28,
						Tip_distance = 0.0,
						Root_chord = 0.0765,
						Tip_chord = 0.055,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"Rudder_Plane.001",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "Prop",
			type = "propeller",
			pivot = { x = 0.0, y = 23.902473, z = 29.579454 },
			angle = 89.276321,
			spinDirection = 1,
			pusher = 0,
			folding = 0,
			blurRadius = 13.191948,
			blurTexture = "None",

			attributes =
			{
				Position = { x = 0.0, y = 23.902473, z = 29.579454 },
				Diameter = 0.254,
				Pitch = 0.11938,
				Blade_count = 2,
				Idle_RPM = 0,
				Max_RPM = 18000,
				Throttle_Curve = 1.0,
				Down_thrust = 0.0,
				Right_thrust = 0.0,
				Torque = 100.0,
				Response = { load = 1.0, unload = 1.0 },
				Engine = "Medium electric",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			spinGeometry = 
			{

				"PropNut_Cylinder.",
			},

			blurGeometry = 
			{

				"Prop_Cube.001",
			},

			exhaust = 
			{

			},

		},

	},

	gear = 
	{

		{
			name = "Main Gear",
			root_pivot = { x = 4.031268, y = 12.356118, z = 10.741863 },
			tip_pivot = { x = 3.876218, y = 12.356114, z = 18.82671 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 0,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "Wheel",
					pivot = { x = 10.063467, y = 3.656836, z = 17.606632 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 1.56518,
					radius = 3.261374,

					sides =
					{
						{

						},

						{

						},

					},

				},

			},

		},

	},

}