modelTypes.FT_3D = 
{

	-- header

	name = "FT 3D",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "Flite Test",
	revision = 1.0,
	formatVersion = "5.5.f",
	minProgramVersion = "5.0.a",
	description = "by Richard Kennedy & Jeff Andvik",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Electric",
	style = "Aerobatic",
	power = "Electric",
	level = "Advanced",

	supportsTrainingGear = 0,


	nodeCount = 60,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 100.0,
			Size = 0.838,
			Weight = 0.5,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 18.266037, z = -1.254871 },
			Inertia = { yaw = 1.5, pitch = 1.5, roll = 0.8 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "None",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = { severity = 100.0, limit = 100.0, speed = 100.0 },
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Torque = 100.0,
			Ground_Torque_Effect = 100.0,
			Rudder_Roll_Coupling = 0.0,
			Rudder_Elevator_Coupling = 0.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Foam",

		geometry = 
		{

			"01_RightWing_Vortex_Generators_Plane.012",
			"06_PowerPod_Cube.008",
			"05_Cockpit_Cube.004",
			"01_LeftWing_Vortex_Generators_Plane.025",
			"06_Motor_Plane.014",
			"05_Fuse_Top_Bottom_Plane.002",
			"05_Fuse_Sides_Plane",
		},

		collision = 
		{

			{ name = "05_Fuse_Sides_Plane2", material = "Inherit", type = "box", x = 0.039446, y = 20.435921, z = -15.301422, width = 7.057472, height = 16.904322, length = 71.73159, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
		},

	},

	airfoils = 
	{

		{
			name = "Main Wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.0, y = 18.354248, z = 5.628767 },
				Length = 0.419,
				Root_chord = 0.245,
				Tip_chord = 0.165,
				Airfoil = "NACA 0014",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 0.0,
				Robustness = 100.0,
				Wash = 150.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"01_LeftWing_Plane.009",
					},

					collision = 
					{

						{ name = "01_LeftWing_Plane.", material = "Inherit", type = "mesh", node = "01_LeftWing_Plane.009", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

						"01_RightWing_Plane.029",
					},

					collision = 
					{

						{ name = "01_RightWing_Plane.", material = "Inherit", type = "mesh", node = "01_RightWing_Plane.029", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Ailerons",
					root_pivot = { x = 3.751054, y = 18.314381, z = -13.698229 },
					tip_pivot = { x = 49.889114, y = 18.398979, z = -4.876931 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.385,
						Tip_distance = 0.0,
						Root_chord = 0.077,
						Tip_chord = 0.077,
						Min_travel = 30.0,
						Max_travel = 30.0,
					},

					sides =
					{
						{

							"01_LeftWing_Aileron_Plane.013",
						},

						{

							"01_RightWing_Aileron_Plane.027",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Stabiliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.0, y = 18.802015, z = -43.807735 },
				Length = 0.165,
				Root_chord = 0.148,
				Tip_chord = 0.086,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 15.5,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"03_Stabiliser_Plane.006",
					},

					collision = 
					{

						{ name = "03_Stabiliser_Plane.", material = "Inherit", type = "mesh", node = "03_Stabiliser_Plane.006", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
						{ name = "03_Elevator_Plane.", material = "Inherit", type = "mesh", node = "03_Elevator_Plane.008", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Elevator",
					root_pivot = { x = -18.906887, y = 18.776253, z = -51.640717 },
					tip_pivot = { x = 18.816353, y = 18.781279, z = -51.589001 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.14,
						Tip_distance = 0.0,
						Root_chord = 0.0788,
						Tip_chord = 0.064,
						Min_travel = 45.0,
						Max_travel = 45.0,
					},

					sides =
					{
						{

							"03_Elevator_Plane.008",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = -0.000332, y = 11.957834, z = -34.783863 },
				Length = 0.215,
				Root_chord = 0.252,
				Tip_chord = 0.09,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 31.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"04_Fin_Plane.004",
					},

					collision = 
					{

						{ name = "04_Fin_Plane.", material = "Inherit", type = "mesh", node = "04_Fin_Plane.004", x = 0.0, y = 0.0, z = 0.0, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
						{ name = "04_Rudder_Plane.", material = "Inherit", type = "mesh", node = "04_Rudder_Plane.005", x = 0.0, y = -0.000002, z = 0.000004, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = 0.00018, y = 11.965779, z = -51.962227 },
					tip_pivot = { x = -0.001504, y = 33.898132, z = -51.920349 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.215,
						Tip_distance = 0.0,
						Root_chord = 0.108,
						Tip_chord = 0.057,
						Min_travel = 60.0,
						Max_travel = 60.0,
					},

					sides =
					{
						{

							"04_Rudder_Plane.005",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "Prop",
			type = "propeller",
			pivot = { x = 0.0, y = 21.528982, z = 21.912508 },
			angle = -89.887299,
			spinDirection = 1,
			pusher = 0,
			folding = 0,
			blurRadius = 15.639304,
			blurTexture = "None",

			attributes =
			{
				Position = { x = 0.0, y = 21.528982, z = 21.912508 },
				Diameter = 0.254,
				Pitch = 0.11938,
				Blade_count = 2,
				Idle_RPM = 0,
				Max_RPM = 12500,
				Throttle_Curve = 0.8,
				Down_thrust = 0.0,
				Right_thrust = 0.0,
				Torque = 100.0,
				Response = { load = 3.5, unload = 1.5 },
				Engine = "480 sized electric",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			spinGeometry = 
			{

				"06_Prop_Nut_Cylinder.008",
			},

			blurGeometry = 
			{

				"06_Prop_Cube.009",
			},

			exhaust = 
			{

			},

		},

	},

	gear = 
	{

		{
			name = "Main Gear",
			root_pivot = { x = 3.40157, y = 11.757682, z = -0.818761 },
			tip_pivot = { x = 3.650462, y = 11.757682, z = 7.875961 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 0,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 0.0,
				Robustness = 100.0,
				Stiffness = 300.0,
				Friction = { frontal = 50.0, lateral = 400.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"02_MainGear_Cylinder.004",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "Wheels",
					pivot = { x = 9.038054, y = 4.183655, z = 4.07346 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 1.567693,
					radius = 2.795757,

					sides =
					{
						{

							"02_LeftWheel_Cylinder.001",
						},

						{

							"02_RightWheel_Cylinder.005",
						},

					},

				},

			},

		},

	},

}