modelTypes.FA_22_Raptor_turbine = 
{

	-- header

	name = "FA-22_Raptor turbine",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Park-flier",
	power = "Turbine",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 80,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.0,
			Weight = 3.5,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 24.200006, z = 0.0 },
			Inertia = { yaw = 1.5, pitch = 1.5, roll = 1.5 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "None",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 300.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 25.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Plastic",

		geometry = 
		{

			"default",
			"LOD0",
			"default2",
			"default3",
			"default4",
			"default5",
			"default6",
			"FA_22_Raptor:Eject_Seat01",
			"default7",
			"FA_22_Raptor:EngineR01",
			"default8",
			"FA_22_Raptor:EngineL01",
			"default9",
			"default10",
			"default11",
			"FA_22_Raptor:FlapL01",
			"default12",
			"FA_22_Raptor:FlapR01",
			"default13",
			"default14",
			"default15",
			"FA_22_Raptor:VoletL01",
			"default16",
			"FA_22_Raptor:VoletR01",
			"default17",
			"default18",
			"default19",
			"FA_22_Raptor:ElevatorR02",
			"default20",
			"FA_22_Raptor:ElevatorL02",
			"default21",
			"FA_22_Raptor:ElevatorL03",
			"default22",
			"FA_22_Raptor:ElevatorR03",
			"default23",
			"canopy1",
			"default24",
			"default25",
			"default26",
			"default27",
			"default28",
			"default29",
			"default30",
			"default31",
			"default32",
			"default33",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "sphere", x = -0.006373, y = 30.93191, z = 137.434113, radius = 2.371177 },
			{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.005342, y = 31.302349, z = 115.207344, radius = 7.78889 },
			{ name = "New Collision3", material = "Inherit", type = "sphere", x = -0.003702, y = 21.115185, z = 79.830116, radius = 3.426935 },
			{ name = "New Collision4", material = "Inherit", type = "sphere", x = -0.003556, y = 53.158443, z = 76.681473, radius = 3.01018 },
			{ name = "New Collision5", material = "Inherit", type = "sphere", x = -0.001082, y = 47.046131, z = 23.33787, radius = 2.723092 },
			{ name = "New Collision6", material = "Inherit", type = "sphere", x = 23.940746, y = 25.190083, z = 41.944813, radius = 7.93049 },
			{ name = "New Collision7", material = "Inherit", type = "sphere", x = -24.231474, y = 25.342741, z = 41.972221, radius = 8.028614 },
			{ name = "New Collision8", material = "Inherit", type = "box", x = 70.739845, y = 30.352375, z = -27.020714, width = 97.294525, height = 2.240862, length = 6.494738, rot_x = -0.008512, rot_y = 0.341945, rot_z = -0.009194, rot_w = 0.939636 },
			{ name = "New Collision9", material = "Inherit", type = "box", x = -71.024315, y = 31.363773, z = -24.812857, width = 96.936653, height = 2.438082, length = 6.360055, rot_x = -0.006018, rot_y = -0.342127, rot_z = 0.014688, rot_w = 0.939519 },
			{ name = "New Collision10", material = "Inherit", type = "box", x = 0.000004, y = 17.888681, z = -18.992962, width = 24.033802, height = 1.0, length = 75.020454, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision11", material = "Inherit", type = "box", x = 34.466805, y = 59.237003, z = -77.239059, width = 2.669081, height = 5.900759, length = 46.774261, rot_x = 0.517217, rot_y = -0.123519, rot_z = -0.197146, rot_w = 0.823628 },
			{ name = "New Collision12", material = "Inherit", type = "box", x = -34.305038, y = 59.705315, z = -77.308281, width = 2.735969, height = 5.528927, length = 48.382099, rot_x = 0.509728, rot_y = 0.139364, rot_z = 0.188592, rot_w = 0.827761 },
			{ name = "New Collision13", material = "Inherit", type = "box", x = 50.919819, y = 31.320759, z = -112.420464, width = 50.694588, height = 2.883367, length = 7.136448, rot_x = -0.00417, rot_y = 0.376586, rot_z = -0.021826, rot_w = 0.926115 },
			{ name = "New Collision14", material = "Inherit", type = "box", x = -51.356674, y = 31.61821, z = -111.425552, width = 49.359264, height = 2.471126, length = 6.3234, rot_x = -0.00445, rot_y = -0.359648, rot_z = 0.01684, rot_w = 0.932925 },
			{ name = "New Collision15", material = "Inherit", type = "sphere", x = 0.0, y = 32.145084, z = -132.846664, radius = 4.279726 },
			{ name = "New Collision16", material = "Inherit", type = "sphere", x = 44.288307, y = 32.249523, z = -154.988998, radius = 1.566907 },
			{ name = "New Collision17", material = "Inherit", type = "sphere", x = -44.400406, y = 32.179264, z = -154.946732, radius = 1.534295 },
		},

	},

	airfoils = 
	{

		{
			name = "wings Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 31.993359, y = 32.727638, z = 8.168429 },
				Length = 0.98,
				Root_chord = 1.12,
				Tip_chord = 0.29,
				Airfoil = "NACA 0009",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = -3.0,
				Sweep = 40.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "ailerons Control surface",
					root_pivot = { x = 70.70536, y = 30.845638, z = -81.292648 },
					tip_pivot = { x = 91.628052, y = 30.048397, z = -75.13707 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.275,
						Tip_distance = 0.2,
						Root_chord = 0.125,
						Tip_chord = 0.125,
						Min_travel = 50.0,
						Max_travel = 50.0,
					},

					sides =
					{
						{

							"FA_22_Raptor:AileronL01",
						},

						{

							"FA_22_Raptor:AileronR01",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "elevator Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 29.66382, y = 32.909954, z = -91.554504 },
				Length = 0.55,
				Root_chord = 0.51,
				Tip_chord = 0.2,
				Airfoil = "NACA 0009",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = -3.0,
				Sweep = 43.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "elevator Control surface",
					root_pivot = { x = 29.628632, y = 32.682106, z = -120.030411 },
					tip_pivot = { x = 59.967636, y = 31.464096, z = -120.096451 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.55,
						Tip_distance = 0.0,
						Root_chord = 0.51,
						Tip_chord = 0.2,
						Min_travel = 2.0,
						Max_travel = 5.0,
					},

					sides =
					{
						{

							"FA_22_Raptor:ElevatorL01",
							"FA_22_Raptor:ElevatorR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "left rudder Airfoil",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 23.144236, y = 37.309063, z = -65.31028 },
				Length = 0.52,
				Root_chord = 0.628,
				Tip_chord = 0.18,
				Airfoil = "NACA 0009",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 63.0,
				Sweep = 25.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "left Control surface",
					root_pivot = { x = 25.307926, y = 39.469692, z = -115.020187 },
					tip_pivot = { x = 44.368336, y = 78.819366, z = -95.052254 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.49,
						Tip_distance = 0.0,
						Root_chord = 0.12,
						Tip_chord = 0.106,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"FA_22_Raptor:RudderL01",
						},

						{

						},

					},

				},

				{
					name = "right Control surface",
					root_pivot = { x = -24.48978, y = 39.628815, z = -114.732681 },
					tip_pivot = { x = -44.298958, y = 79.170952, z = -94.725975 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.49,
						Tip_distance = 0.0,
						Root_chord = 0.12,
						Tip_chord = 0.106,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"FA_22_Raptor:RudderR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "right rudder Airfoil",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = -23.019415, y = 37.309063, z = -65.31028 },
				Length = 0.52,
				Root_chord = 0.628,
				Tip_chord = 0.18,
				Airfoil = "NACA 0009",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 117.0,
				Sweep = 25.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "left Control surface",
					root_pivot = { x = -24.133347, y = 39.767765, z = -114.894745 },
					tip_pivot = { x = -44.029884, y = 79.189842, z = -94.749298 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.49,
						Tip_distance = 0.0,
						Root_chord = 0.12,
						Tip_chord = 0.106,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "New Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = 9.286031, y = 29.724045, z = -61.534454 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 200.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 200.0,
				Pitch_Tuning = 10.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust",
					position = { x = 106.634018, y = 29.669661, z = -73.712975 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "New Turbine2",
			type = "turbine",

			attributes =
			{
				Position = { x = -9.315701, y = 29.617275, z = -61.547287 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 200.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 80.0,
				Pitch_Tuning = 300.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust2",
					position = { x = -106.81752, y = 29.675432, z = -74.494553 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "front Gear",
			root_pivot = { x = -3.980251, y = 25.453636, z = 60.598984 },
			tip_pivot = { x = 3.968302, y = 25.453636, z = 60.609047 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 0.0, y = 4.0, z = 0.0, angle = 100.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"FrontGear",
							"FrontAxleBar",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "front Wheel",
					pivot = { x = -0.00033, y = 5.33506, z = 58.741798 },
					axis = { x = 1.0, y = -0.0, z = 0.0 },
					width = 4.936453,
					radius = 4.936453,

					sides =
					{
						{

							"FrontWheels",
						},

					},

				},

			},

		},

		{
			name = "front Gear 2",
			root_pivot = { x = 2.649986, y = 26.365751, z = 41.813057 },
			tip_pivot = { x = -2.577045, y = 26.365751, z = 41.82312 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 0.0, y = 3.0, z = -10.0, angle = 40.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"FrontGearRearSupp",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "left Gear",
			root_pivot = { x = 24.313944, y = 22.175262, z = -38.144474 },
			tip_pivot = { x = 18.068579, y = 22.175266, z = -38.109768 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = -14.0, y = 10.0, z = 8.0, angle = -40.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"verrain_haut_train_g",
							"verrain_bas_train_g",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "left Wheel",
					pivot = { x = 34.315147, y = 7.068682, z = -51.708797 },
					axis = { x = 0.999999, y = -0.0, z = 0.0 },
					width = 6.796868,
					radius = 6.796868,

					sides =
					{
						{

							"LeftRearWheel",
						},

					},

				},

			},

		},

		{
			name = "right Gear",
			root_pivot = { x = -17.653238, y = 21.402317, z = -36.961269 },
			tip_pivot = { x = -23.28405, y = 21.402317, z = -37.008476 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 6000.0,
			idle = { x = 14.0, y = 10.0, z = 8.0, angle = -40.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"verrain_bas_train_d",
							"verrain_haut_train_d",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "right Wheel",
					pivot = { x = -34.41671, y = 7.065142, z = -51.689972 },
					axis = { x = 1.000001, y = -0.0, z = -0.0 },
					width = 6.783072,
					radius = 6.783072,

					sides =
					{
						{

							"RightRearWheel",
						},

					},

				},

			},

		},

		{
			name = "left front trap Gear",
			root_pivot = { x = 4.40875, y = 20.107529, z = 38.662052 },
			tip_pivot = { x = 4.40875, y = 21.963514, z = 61.423492 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 0.4, y = 0.2, z = 0.0, angle = -90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"front_trap_g",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "right front trap Gear",
			root_pivot = { x = -4.371916, y = 20.330816, z = 38.716061 },
			tip_pivot = { x = -4.619172, y = 21.975885, z = 61.435303 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = -0.15, y = -0.1, z = 0.0, angle = 90.999802 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"front_trap_d",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "left trap back  Gear",
			root_pivot = { x = 38.532555, y = 31.543755, z = -47.182838 },
			tip_pivot = { x = 38.532555, y = 31.543755, z = -37.779537 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 0.0, y = 0.3, z = 0.0, angle = -65.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"ar_g_trap_g",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "right trap back Gear",
			root_pivot = { x = -38.041565, y = 32.089615, z = -47.201599 },
			tip_pivot = { x = -38.041565, y = 32.089615, z = -37.588375 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 6000.0,
			idle = { x = -0.4, y = 0.0, z = 0.0, angle = 65.699997 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"ar_d_trap_d",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

	},

	pilots = 
	{

		{
			name = "lagoul",
			position = { x = 0.0, y = 43.350849, z = 70.573471 },
			size = 0.843324,


			attributes =
			{
				Type = "Fighter_pilot",
			},

		},

	},

}