modelTypes.EF_111A_Raven_turbine = 
{

	-- header

	name = "EF-111A_Raven turbine",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Park-flier",
	power = "Turbine",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 68,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.0,
			Weight = 4.0,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 2.314198, z = 21.140541 },
			Inertia = { yaw = 1.5, pitch = 1.5, roll = 1.5 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Jet_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 300.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 30.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Plastic",

		geometry = 
		{

			"default",
			"default2",
			"default3",
			"default4",
			"default5",
			"VoletL05",
			"default6",
			"VoletR05",
			"default7",
			"default8",
			"default9",
			"default10",
			"default11",
			"default12",
			"default13",
			"default14",
			"default15",
			"default16",
			"default17",
			"default18",
			"default19",
			"default20",
			"default21",
			"default22",
			"default23",
			"default24",
			"default25",
			"default26",
			"default27",
			"default28",
			"default29",
			"default30",
			"default31",
			"default32",
			"default33",
			"default34",
			"default35",
			"default36",
			"default37",
			"Glass_Canopy02",
			"default38",
			"Glass_Canopy01",
			"default39",
			"default40",
			"default41",
			"default42",
			"Glass01",
			"default43",
			"EngineR01",
			"default44",
			"EngineL01",
			"default45",
			"Pilot02",
			"default46",
			"Eject_Seat02",
			"default47",
			"Pilot01",
			"default48",
			"Eject_Seat01",
			"default49",
			"LOD0",
			"default50",
			"default51",
			"default52",
			"default53",
			"default54",
			"default55",
			"default56",
			"default57",
			"default58",
		},

		collision = 
		{

			{ name = "New Collision3", material = "Inherit", type = "box", x = -80.000366, y = 37.974499, z = -27.303232, width = 91.578903, height = 6.404253, length = 6.605876, rot_x = 0.0, rot_y = -0.148005, rot_z = 0.0, rot_w = 0.988987 },
			{ name = "New Collision4", material = "Inherit", type = "box", x = 41.566399, y = 37.852322, z = -109.985512, width = 67.306007, height = 5.428438, length = 7.278594, rot_x = 0.0, rot_y = 0.511157, rot_z = 0.0, rot_w = 0.859487 },
			{ name = "New Collision5", material = "Inherit", type = "box", x = -41.344421, y = 37.979393, z = -110.451492, width = 70.424248, height = 5.321862, length = 6.813083, rot_x = 0.001292, rot_y = -0.489218, rot_z = 0.002304, rot_w = 0.872158 },
			{ name = "New Collision6", material = "Inherit", type = "box", x = 0.004689, y = 56.150402, z = -101.120193, width = 3.374215, height = 4.780813, length = 45.50843, rot_x = 0.280298, rot_y = 0.0, rot_z = 0.0, rot_w = 0.959913 },
			{ name = "New Collision", material = "Inherit", type = "box", x = 77.247581, y = 38.128307, z = -27.140713, width = 94.090599, height = 5.230073, length = 6.140337, rot_x = 0.0, rot_y = 0.149135, rot_z = 0.0, rot_w = 0.988817 },
			{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.006558, y = 20.241859, z = 141.411652, radius = 2.391493 },
			{ name = "New Collision7", material = "Inherit", type = "sphere", x = -0.005267, y = 19.679571, z = 113.579231, radius = 6.741368 },
			{ name = "New Collision8", material = "Inherit", type = "sphere", x = -0.00219, y = 43.857403, z = 47.231094, radius = 3.930944 },
			{ name = "New Collision9", material = "Inherit", type = "sphere", x = 0.005554, y = 78.156075, z = -119.764618, radius = 5.280282 },
			{ name = "New Collision10", material = "Inherit", type = "sphere", x = 0.007314, y = 84.060036, z = -157.717728, radius = 3.37468 },
			{ name = "New Collision11", material = "Inherit", type = "sphere", x = 0.007131, y = 24.177805, z = -153.781708, radius = 3.391313 },
			{ name = "New Collision12", material = "Inherit", type = "box", x = 0.0, y = 17.689684, z = 0.0, width = 9.024249, height = 6.451564, length = 157.236649, rot_x = 0.020898, rot_y = 0.0, rot_z = 0.0, rot_w = 0.999782 },
		},

	},

	airfoils = 
	{

		{
			name = "wings Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 24.768206, y = 37.799992, z = -10.237483 },
				Length = 1.02,
				Root_chord = 0.48,
				Tip_chord = 0.18,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 17.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 91.643448, y = 37.681671, z = -49.96529 },
					tip_pivot = { x = 120.366081, y = 37.826225, z = -53.024296 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.3,
						Tip_distance = 0.02,
						Root_chord = 0.08,
						Tip_chord = 0.05,
						Min_travel = 50.0,
						Max_travel = 50.0,
					},

					sides =
					{
						{

						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "elevators Airfoil",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 22.456282, y = 38.000023, z = -76.616142 },
				Length = 0.7,
				Root_chord = 0.67,
				Tip_chord = 0.18,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 60.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 22.99049, y = 38.118534, z = -115.969475 },
					tip_pivot = { x = 44.888435, y = 37.694832, z = -115.962013 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.7,
						Tip_distance = 0.0,
						Root_chord = 0.67,
						Tip_chord = 0.18,
						Min_travel = 10.0,
						Max_travel = 10.0,
					},

					sides =
					{
						{

							"ElevatorR01",
							"ElevatorL01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "rudder Airfoil",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.003679, y = 39.397575, z = -76.133026 },
				Length = 0.8,
				Root_chord = 0.69,
				Tip_chord = 0.18,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 56.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 0.070553, y = 39.342953, z = -121.968285 },
					tip_pivot = { x = -0.018588, y = 68.885246, z = -141.106888 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.55,
						Tip_distance = 0.25,
						Root_chord = 0.23,
						Tip_chord = 0.14,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"RudderL01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "left Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = 8.85712, y = 30.288378, z = -70.011391 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 100.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 50.0,
				Pitch_Tuning = 300.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust",
					position = { x = 8.910668, y = 24.949881, z = -126.15242 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "right Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = -8.755714, y = 30.324789, z = -70.011055 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 100.0,
				Spool_Time = 5.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 20.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust2",
					position = { x = -8.678218, y = 25.259815, z = -126.812881 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "front Gear",
			root_pivot = { x = 4.244066, y = 19.913425, z = 76.07769 },
			tip_pivot = { x = -3.554828, y = 19.913425, z = 76.060883 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"train_d_attrissage:FrontGear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "New Wheel",
					pivot = { x = 0.00217, y = 4.065918, z = 74.642044 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 8.093922,
					radius = 3.968513,

					sides =
					{
						{

							"train_d_attrissage:FrontWheels",
						},

					},

				},

			},

		},

		{
			name = "front Gear2",
			root_pivot = { x = 2.870865, y = 18.242582, z = 58.386261 },
			tip_pivot = { x = -2.930651, y = 18.242582, z = 58.386925 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 0.0, y = 2.0, z = -10.0, angle = 30.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"train_d_attrissage:FrontGearRearSupp",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "rear left Gear",
			root_pivot = { x = 10.02549, y = 17.560196, z = -34.658779 },
			tip_pivot = { x = 5.755892, y = 15.7257, z = -34.637814 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = -4.0, y = 6.0, z = 10.0, angle = -70.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"train_d_attrissage:verrain_bas_train_g",
							"train_d_attrissage:verrain_haut_train_g",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"train_d_attrissage:verrain_bas_train_d",
							"train_d_attrissage:verrain_haut_train_d",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "rear left Wheel2",
					pivot = { x = 19.128651, y = 5.549984, z = -46.744148 },
					axis = { x = 1.0, y = 0.0, z = -0.0 },
					width = 2.812049,
					radius = 5.502324,

					sides =
					{
						{

							"train_d_attrissage:LeftRearWheel",
						},

						{

						},

					},

				},

				{
					name = "rear right Wheel2",
					pivot = { x = -18.998859, y = 5.535965, z = -46.71447 },
					axis = { x = 1.0, y = 0.0, z = -0.0 },
					width = 3.058476,
					radius = 5.520908,

					sides =
					{
						{

						},

						{

							"train_d_attrissage:RightRearWheel",
						},

					},

				},

			},

		},

		{
			name = "front traps",
			root_pivot = { x = 5.376664, y = 14.597836, z = 51.658604 },
			tip_pivot = { x = 6.031436, y = 14.597836, z = 82.017815 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 0.0, y = -1.2, z = 0.0, angle = -98.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"left_front_trap",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"right_front_trap",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

		{
			name = "rear traps",
			root_pivot = { x = -0.017508, y = 19.896425, z = -52.48188 },
			tip_pivot = { x = -0.018448, y = 17.426193, z = -17.196041 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 4000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 50.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"rear_left_trap1",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"rear_right_trap",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

			},

		},

	},

	widgets = 
	{

		{
			name = "wings Widget",
			root_pivot = { x = 29.027344, y = 30.538527, z = -17.4625 },
			tip_pivot = { x = 29.027344, y = 44.336689, z = -17.411444 },
			mirrored = 1,
			changeTime = 4000.0,
			input = "Flaps",
			idle = { x = -1.0, y = 0.0, z = 0.0, angle = 52.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"WingL01",
							"PylonL02",
							"PylonL01",
							"VoletL06",
							"VoletL04",
							"VoletL03",
							"VoletL02",
							"VoletL01",
							"BrakeL03",
							"BrakeL02",
							"BrakeL01",
							"FlapL03",
							"FlapL02",
							"FlapL01",
							"AileronL01",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"WingR01",
							"PylonR02",
							"PylonR01",
							"VoletR06",
							"VoletR04",
							"VoletR03",
							"VoletR02",
							"VoletR01",
							"BrakeR03",
							"BrakeR02",
							"BrakeR01",
							"AileronR01",
							"FlapR03",
							"FlapR02",
							"FlapR01",
					},

					collision = 
					{

					},

				},

			},

		},

	},

}