modelTypes.Dassault_Mirage_F1 = 
{

	-- header

	name = "Dassault Mirage F1",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.0.c",
	minProgramVersion = "5.0.a",
	description = "Scale ducted-fan jet",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Electric",
	style = "Park-flier",
	power = "Electric",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 83,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 0.885,
			Weight = 1.75,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 19.075727, z = -9.925898 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.029793, lateral = 0.203609, vertical = 0.203609 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Jet_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = 100.0,
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Ground_Torque_Effect = 100.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Foam",

		geometry = 
		{

			"LOD0",
			"Canopy01",
			"Glass_Canopy01",
			"Glass_HUD",
			"EngineL01",
			"Glass",
			"FlapL01",
			"BrakeL01",
			"BrakeR01",
			"FlapR01",
			"FlapR02",
			"FlapL02",
			"VoletL01",
			"VoletL02",
			"VoletR01",
			"VoletR02",
			"IntakeR01",
			"IntakeR02",
			"IntakeL01",
			"IntakeL02",
			"BrakeL02",
			"BrakeR02",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "sphere", x = -0.003493, y = 11.096467, z = 75.32782, radius = 1.613447 },
			{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.002692, y = 12.106917, z = 58.058323, radius = 2.87953 },
			{ name = "New Collision3", material = "Inherit", type = "sphere", x = -0.002036, y = 12.933649, z = 43.912018, radius = 5.271375 },
			{ name = "New Collision4", material = "Inherit", type = "sphere", x = -0.001538, y = 21.29283, z = 33.164539, radius = 3.548781 },
			{ name = "New Collision5", material = "Inherit", type = "sphere", x = -0.002539, y = 20.374237, z = 54.751431, radius = 2.715085 },
			{ name = "New Collision6", material = "Inherit", type = "sphere", x = -0.00083, y = 8.40454, z = 17.900892, radius = 2.715085 },
			{ name = "New Collision7", material = "Inherit", type = "sphere", x = 0.000617, y = 5.983707, z = -13.301024, radius = 2.715085 },
			{ name = "New Collision8", material = "Inherit", type = "sphere", x = 0.00222, y = 5.580236, z = -47.865185, radius = 4.626712 },
			{ name = "New Collision9", material = "Inherit", type = "sphere", x = 0.003367, y = 14.994607, z = -72.611526, radius = 6.63975 },
			{ name = "New Collision10", material = "Inherit", type = "sphere", x = 0.003461, y = 41.22036, z = -74.628891, radius = 3.188446 },
			{ name = "New Collision11", material = "Inherit", type = "sphere", x = 0.002937, y = 42.430779, z = -63.33165, radius = 5.347586 },
			{ name = "New Collision12", material = "Inherit", type = "sphere", x = 9.706032, y = 14.632932, z = 21.455406, radius = 3.770448 },
			{ name = "New Collision13", material = "Inherit", type = "sphere", x = -9.931297, y = 14.632932, z = 21.455406, radius = 3.770448 },
			{ name = "New Collision14", material = "Inherit", type = "sphere", x = -42.506142, y = 16.425503, z = -36.532444, radius = 9.27864 },
			{ name = "New Collision15", material = "Inherit", type = "sphere", x = 42.622952, y = 16.425503, z = -36.532444, radius = 9.27864 },
			{ name = "New Collision16", material = "Inherit", type = "sphere", x = 26.451048, y = 13.719847, z = -70.493454, radius = 9.27864 },
			{ name = "New Collision17", material = "Inherit", type = "sphere", x = -26.367317, y = 13.719847, z = -70.493454, radius = 9.27864 },
		},

	},

	airfoils = 
	{

		{
			name = "Main wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 7.79214, y = 19.249966, z = 7.792061 },
				Length = 0.4602,
				Root_chord = 0.3717,
				Tip_chord = 0.13275,
				Airfoil = "NACA 2314",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 47.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "left aileron",
					root_pivot = { x = 31.918663, y = 17.053782, z = -35.749153 },
					tip_pivot = { x = 42.827457, y = 15.923395, z = -40.712479 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.15045,
						Tip_distance = 0.0,
						Root_chord = 0.0531,
						Tip_chord = 0.039825,
						Min_travel = 40.0,
						Max_travel = 40.0,
					},

					sides =
					{
						{

							"AileronL01",
						},

						{

							"AileronR01",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Stabiliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 6.809885, y = 13.699374, z = -45.343689 },
				Length = 0.2655,
				Root_chord = 0.23895,
				Tip_chord = 0.07965,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 49.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "left_elevator",
					root_pivot = { x = 5.996508, y = 13.770306, z = -60.241142 },
					tip_pivot = { x = 19.633959, y = 13.647566, z = -60.159611 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.27435,
						Tip_distance = 0.0,
						Root_chord = 0.1062,
						Tip_chord = 0.147795,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"ElevatorL01",
							"ElevatorR01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.00141, y = 22.200031, z = -31.037737 },
				Length = 0.354,
				Root_chord = 0.30975,
				Tip_chord = 0.09735,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 58.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = -0.032202, y = 25.189236, z = -60.379494 },
					tip_pivot = { x = 0.001049, y = 38.386326, z = -68.979324 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.22125,
						Tip_distance = 0.084075,
						Root_chord = 0.06195,
						Tip_chord = 0.039825,
						Min_travel = 40.0,
						Max_travel = 40.0,
					},

					sides =
					{
						{

							"RudderL01",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "Ducted fan",
			type = "turbine",

			attributes =
			{
				Position = { x = 0.0, y = 15.705446, z = -0.010371 },
				Idle_RPM = 0.0,
				Max_RPM = 25000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 30.0,
				Spool_Time = 0.5,
				Engine = "Icon A5 electric",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust",
					position = { x = 0.003283, y = 15.415838, z = -70.872742 },
					vector = { x = 0.0, y = 0.038969, z = -0.999241 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	pilots = 
	{

		{
			name = "Pilot",
			position = { x = -0.001591, y = 15.690558, z = 29.859524 },
			size = 0.595567,


			attributes =
			{
				Type = "Fighter_pilot",
			},

		},

	},

}