modelTypes.C_5_Galaxy_turbine = 
{

	-- header

	name = "C-5 Galaxy turbine",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.5.e",
	minProgramVersion = "5.0.a",
	description = "",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Scale",
	power = "Electric",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 51,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.0,
			Weight = 7.0,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 21.283268, z = 34.948044 },
			Inertia = { yaw = 1.5, pitch = 1.5, roll = 1.5 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Jet_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = { severity = 100.0, limit = 100.0 },
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Torque = 100.0,
			Ground_Torque_Effect = 100.0,
			Rudder_Roll_Coupling = 0.0,
			Rudder_Elevator_Coupling = 0.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 40.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Wood",

		geometry = 
		{

			"default",
			"left_moteur2",
			"default2",
			"left_moteur3",
			"default3",
			"right_moteur3",
			"default4",
			"right_moteur4",
			"default5",
			"default6",
			"default7",
			"default8",
			"default9",
			"default10",
			"default11",
			"default12",
			"default13",
			"default14",
			"default15",
			"default16",
			"default17",
			"default18",
			"default19",
			"default20",
			"default21",
			"default22",
			"default23",
			"default24",
			"default25",
			"default26",
			"default27",
			"default28",
			"default29",
			"default30",
			"default31",
			"default32",
			"default33",
			"lodo_c_5",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "sphere", x = -0.006951, y = 22.730547, z = 149.898666, radius = 2.682752 },
			{ name = "New Collision2", material = "Inherit", type = "box", x = 0.0, y = 6.8129, z = 36.552902, width = 20.572325, height = 2.241913, length = 129.955811, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision3", material = "Inherit", type = "box", x = 0.0, y = 43.618294, z = 11.365298, width = 8.529505, height = 2.894681, length = 200.695129, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "New Collision4", material = "Inherit", type = "box", x = 0.004826, y = 22.976274, z = -104.068932, width = 8.224115, height = 4.487057, length = 112.372864, rot_x = 0.111276, rot_y = 0.0, rot_z = 0.0, rot_w = 0.99379 },
			{ name = "New Collision5", material = "Inherit", type = "box", x = 0.005867, y = 64.717293, z = -126.529076, width = 3.184102, height = 3.915462, length = 46.766827, rot_x = 0.440385, rot_y = 0.0, rot_z = 0.0, rot_w = 0.897809 },
			{ name = "New Collision6", material = "Inherit", type = "box", x = 84.7285, y = 30.613838, z = 14.079529, width = 147.495789, height = 3.898533, length = 3.970496, rot_x = -0.010148, rot_y = 0.240868, rot_z = -0.040852, rot_w = 0.969645 },
			{ name = "New Collision7", material = "Inherit", type = "box", x = -84.225677, y = 30.82324, z = 13.325249, width = 141.367599, height = 4.026554, length = 5.597825, rot_x = -0.009398, rot_y = -0.241356, rot_z = 0.037756, rot_w = 0.969656 },
			{ name = "New Collision8", material = "Inherit", type = "box", x = 26.135195, y = 86.730011, z = -153.107422, width = 49.385502, height = 3.289385, length = 2.813757, rot_x = -0.010823, rot_y = 0.248095, rot_z = -0.042219, rot_w = 0.967755 },
			{ name = "New Collision9", material = "Inherit", type = "box", x = -26.13501, y = 87.030235, z = -153.130142, width = 51.115227, height = 3.074625, length = 2.942209, rot_x = -0.011234, rot_y = -0.246233, rot_z = 0.044171, rot_w = 0.968138 },
		},

	},

	airfoils = 
	{

		{
			name = "Main wings",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 18.00675, y = 36.941631, z = 49.731094 },
				Length = 1.48,
				Root_chord = 0.55,
				Tip_chord = 0.21,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = -5.5,
				Sweep = 28.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 66.983093, y = 32.347557, z = -8.630417 },
					tip_pivot = { x = 107.526611, y = 28.346479, z = -20.396667 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.456,
						Tip_distance = 0.465,
						Root_chord = 0.1,
						Tip_chord = 0.095,
						Min_travel = 40.0,
						Max_travel = 40.0,
					},

					sides =
					{
						{

							"left_aileron",
						},

						{

							"right_aileron",
						},

					},

				},

			},

			flaps = {

				{
					name = "Flap",
					root_pivot = { x = 17.960779, y = 36.878483, z = 6.04374 },
					tip_pivot = { x = 67.390434, y = 32.476936, z = -9.039622 },
					is_leading_edge = 0,

					attributes =
					{
						Length = 0.57,
						Root_Chord = 0.11,
						Tip_Chord = 0.1,
						Tip_distance = 0.91,
						Travel = 20.0,
						Lift_increase = 5.0,
						Drag_increase = 5.0,
					},

					sides =
					{
						{

							"left_flap",
						},

						{

							"right_flap",
						},

					},

				},

				{
					name = "left front Flap",
					root_pivot = { x = 17.985876, y = 37.034573, z = 44.034916 },
					tip_pivot = { x = 138.149963, y = 25.831142, z = -18.827576 },
					is_leading_edge = 1,

					attributes =
					{
						Length = 1.37,
						Root_Chord = 0.06,
						Tip_Chord = 0.045,
						Tip_distance = 0.11,
						Travel = 20.0,
						Lift_increase = 5.0,
						Drag_increase = 5.0,
					},

					sides =
					{
						{

							"left_front_flap",
						},

						{

							"right_front_flap",
						},

					},

				},

			},

			airbrakes = {

			},

		},

		{
			name = "Stabilisators",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 2.712358, y = 89.04583, z = -140.282227 },
				Length = 0.52,
				Root_chord = 0.27,
				Tip_chord = 0.089,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = -5.5,
				Sweep = 28.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 2.54143, y = 88.502274, z = -153.131683 },
					tip_pivot = { x = 26.047462, y = 86.608002, z = -153.343216 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.52,
						Tip_distance = 0.0,
						Root_chord = 0.27,
						Tip_chord = 0.089,
						Min_travel = 10.0,
						Max_travel = 10.0,
					},

					sides =
					{
						{

							"left_elevator",
							"right_elevator",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.005075, y = 45.321892, z = -110.16494 },
				Length = 0.52,
				Root_chord = 0.415,
				Tip_chord = 0.33,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 38.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 0.061259, y = 45.239155, z = -139.187469 },
					tip_pivot = { x = -0.007914, y = 84.119308, z = -163.476044 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.49,
						Tip_distance = 0.03,
						Root_chord = 0.125,
						Tip_chord = 0.105,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "left Turbine1",
			type = "turbine",

			attributes =
			{
				Position = { x = 53.295368, y = 22.024149, z = 46.2066 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 25.0,
				Spool_Time = 5.0,
				Throttle_Curve = 0.0,
				Engine = "Turbo-fan",
				Volume_Tuning = 25.0,
				Pitch_Tuning = 300.0,
			},

			exhaust = 
			{

			},

		},

		{
			name = "left Turbine2",
			type = "turbine",

			attributes =
			{
				Position = { x = 82.348434, y = 19.13163, z = 30.434204 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 25.0,
				Spool_Time = 5.0,
				Throttle_Curve = 0.0,
				Engine = "Scale turbine",
				Volume_Tuning = 40.0,
				Pitch_Tuning = 30.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust",
					position = { x = 148.485474, y = 24.144814, z = -40.692616 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "rightTurbine1",
			type = "turbine",

			attributes =
			{
				Position = { x = -53.231556, y = 22.015215, z = 46.206722 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 25.0,
				Spool_Time = 5.0,
				Throttle_Curve = 0.0,
				Engine = "Turbo-fan",
				Volume_Tuning = 40.0,
				Pitch_Tuning = 20.0,
			},

			exhaust = 
			{

			},

		},

		{
			name = "right Turbine2",
			type = "turbine",

			attributes =
			{
				Position = { x = -82.008156, y = 19.12587, z = 30.212107 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 25.0,
				Spool_Time = 5.0,
				Throttle_Curve = 0.0,
				Engine = "Scale turbine",
				Volume_Tuning = 20.0,
				Pitch_Tuning = 300.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust2",
					position = { x = -148.22966, y = 24.019241, z = -40.266178 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "front Gear",
			root_pivot = { x = 3.184327, y = 13.105589, z = 107.971687 },
			tip_pivot = { x = -3.502831, y = 13.10351, z = 108.005188 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = 0.0, y = 0.0, z = 8.0, angle = -90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 50.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"front_gear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "front Wheel",
					pivot = { x = -0.000042, y = 2.885597, z = 107.461243 },
					axis = { x = 1.000001, y = 0.0, z = -0.0 },
					width = 9.813978,
					radius = 2.838787,

					sides =
					{
						{

							"front_wheel2",
						},

					},

				},

			},

		},

		{
			name = "left rear Gear1",
			root_pivot = { x = 15.598488, y = 10.626642, z = 19.823956 },
			tip_pivot = { x = 10.891311, y = 10.624544, z = 19.771933 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = -1.0, y = 0.0, z = 0.0, angle = -100.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"left_rear_gear1",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"right_rear_gear1",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "left rear Wheel1",
					pivot = { x = 13.064126, y = 2.926113, z = 22.16622 },
					axis = { x = 0.999999, y = 0.0, z = 0.0 },
					width = 5.804595,
					radius = 2.868843,

					sides =
					{
						{

							"left_rear_wheel1",
						},

						{

							"right_rear_whell1",
						},

					},

				},

				{
					name = "left rear Wheel2",
					pivot = { x = 13.107971, y = 2.909733, z = 16.188488 },
					axis = { x = 0.999999, y = 0.0, z = 0.0 },
					width = 5.83208,
					radius = 2.874638,

					sides =
					{
						{

							"left_rear_wheel2",
						},

						{

							"right_rear_wheel2",
						},

					},

				},

			},

		},

		{
			name = "left rear Gear2",
			root_pivot = { x = 15.626717, y = 11.14849, z = -3.205479 },
			tip_pivot = { x = 10.257534, y = 11.146403, z = -3.191092 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 1,
			changeTime = 3000.0,
			idle = { x = -1.0, y = 0.0, z = 0.0, angle = -100.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"left_rear_gear2",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"right_rear_gear2",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "left rear Wheel3",
					pivot = { x = 13.152334, y = 2.865627, z = -0.937843 },
					axis = { x = 1.000001, y = -0.0, z = -0.0 },
					width = 5.559093,
					radius = 2.824113,

					sides =
					{
						{

							"left_rear_wheel3",
						},

						{

							"right_rear_wheel3",
						},

					},

				},

				{
					name = "left rear Wheel4",
					pivot = { x = 0.000314, y = 2.886787, z = -6.933677 },
					axis = { x = 1.000001, y = -0.0, z = -0.0 },
					width = 2.811335,
					radius = 2.811335,

					sides =
					{
						{

							"left_rear_wheel4",
						},

						{

							"right_rear_wheel4",
						},

					},

				},

			},

		},

	},

	widgets = 
	{

		{
			name = "left rear trap1",
			root_pivot = { x = 17.657312, y = 9.435646, z = -15.902132 },
			tip_pivot = { x = 17.657312, y = 9.435646, z = 27.203972 },
			mirrored = 1,
			changeTime = 3000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -52.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"rear_left_trap1",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"rear_right_trap1",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "left rear trap2",
			root_pivot = { x = 9.613719, y = 6.211021, z = -15.948915 },
			tip_pivot = { x = 9.613719, y = 6.391575, z = 27.337906 },
			mirrored = 1,
			changeTime = 3000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 187.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"rear_left_trap2",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"rear_right_trap2",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "front trap",
			root_pivot = { x = 7.193005, y = 9.536714, z = 130.439606 },
			tip_pivot = { x = -7.440886, y = 9.535626, z = 130.367096 },
			mirrored = 0,
			changeTime = 3000.0,
			input = "Retract Gear",
			idle = { x = 0.0, y = 0.0, z = -3.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"front_trap",
					},

					collision = 
					{

					},

				},

			},

		},

	},

}