modelTypes.CFA_44_Nosferatu_turbine = 
{

	-- header

	name = "CFA_44_Nosferatu turbine",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "",
	revision = 1.0,
	formatVersion = "5.5.f",
	minProgramVersion = "5.0.a",
	description = "",
	physics = physics.airplane,

	class = "Airplanes",
	subclass = "Scale",
	style = "Scale",
	power = "Turbine",
	level = "Beginner",

	supportsTrainingGear = 0,


	nodeCount = 72,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 1.0,
			Weight = 7.0,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 26.859701, z = 0.0 },
			Inertia = { yaw = 1.2, pitch = 1.2, roll = 1.2 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "Jet_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = { severity = 100.0, limit = 100.0, speed = 100.0 },
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Torque = 100.0,
			Ground_Torque_Effect = 100.0,
			Rudder_Roll_Coupling = 0.0,
			Rudder_Elevator_Coupling = 0.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 35.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Plastic",

		geometry = 
		{

			"default",
			"default2",
			"default3",
			"default4",
			"default5",
			"default6",
			"default7",
			"default8",
			"default9",
			"default10",
			"default11",
			"default12",
			"default13",
			"default14",
			"default15",
			"default16",
			"default17",
			"default18",
			"canope",
			"default19",
			"default20",
			"default21",
			"default23",
			"default24",
			"default25",
			"default26",
			"default27",
			"default28",
			"default29",
			"lodo2",
		},

		collision = 
		{

			{ name = "New Collision", material = "Inherit", type = "box", x = 0.0, y = 28.962503, z = 116.38279, width = 7.699519, height = 3.907604, length = 63.455627, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
				{ name = "New Collision2", material = "Inherit", type = "sphere", x = -0.007381, y = 31.619713, z = 159.161819, radius = 1.756527 },
				{ name = "New Collision3", material = "Inherit", type = "sphere", x = -0.004054, y = 52.610935, z = 87.419106, radius = 2.739673 },
				{ name = "New Collision4", material = "Inherit", type = "box", x = 19.934925, y = 15.291328, z = -19.668676, width = 6.06392, height = 2.477301, length = 39.867596, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
				{ name = "New Collision5", material = "Inherit", type = "box", x = -19.834616, y = 15.226604, z = -19.804235, width = 6.09885, height = 2.293399, length = 39.848362, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
				{ name = "New Collision6", material = "Inherit", type = "sphere", x = 0.007401, y = 28.146301, z = -159.6035, radius = 2.355428 },
				{ name = "New Collision7", material = "Inherit", type = "box", x = 68.527573, y = 33.233875, z = -45.920315, width = 117.413696, height = 3.726965, length = 6.31009, rot_x = -0.003909, rot_y = 0.493605, rot_z = -0.006887, rot_w = 0.86965 },
				{ name = "New Collision8", material = "Inherit", type = "box", x = -69.315453, y = 33.233555, z = -46.776005, width = 115.987503, height = 3.708328, length = 6.474877, rot_x = -0.011287, rot_y = -0.500461, rot_z = 0.006475, rot_w = 0.865661 },
				{ name = "New Collision9", material = "Inherit", type = "box", x = 33.334461, y = 35.615223, z = 36.953716, width = 43.217068, height = 1.873639, length = 4.065423, rot_x = 0.0, rot_y = 0.486914, rot_z = 0.0, rot_w = 0.87345 },
				{ name = "New Collision10", material = "Inherit", type = "box", x = -33.144054, y = 35.739635, z = 36.763218, width = 45.343391, height = 1.814303, length = 3.940821, rot_x = 0.0, rot_y = -0.493541, rot_z = 0.0, rot_w = 0.869722 },
				{ name = "New Collision11", material = "Inherit", type = "sphere", x = -17.028433, y = 19.936611, z = -119.799393, radius = 1.850325 },
				{ name = "New Collision12", material = "Inherit", type = "sphere", x = 18.772921, y = 19.953508, z = -119.856995, radius = 1.842065 },
				{ name = "New Collision13", material = "Inherit", type = "box", x = -38.726841, y = 54.243702, z = -91.932327, width = 2.988707, height = 3.440042, length = 51.137585, rot_x = 0.280546, rot_y = 0.065479, rot_z = 0.258346, rot_w = 0.922098 },
				{ name = "New Collision14", material = "Inherit", type = "box", x = 38.158936, y = 54.209576, z = -91.694717, width = 3.225189, height = 3.458556, length = 51.104832, rot_x = 0.287425, rot_y = -0.083891, rot_z = -0.252663, rot_w = 0.92006 },
				{ name = "New Collision15", material = "Inherit", type = "sphere", x = -0.001586, y = 51.667267, z = 34.202301, radius = 1.681006 },
		},

	},

	airfoils = 
	{

		{
			name = "main wing",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 19.732111, y = 35.599983, z = 33.229084 },
				Length = 1.03,
				Root_chord = 1.5,
				Tip_chord = 0.3,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = -3.0,
				Sweep = 58.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "left aileron control surface",
					root_pivot = { x = 53.721489, y = 33.825951, z = -82.346245 },
					tip_pivot = { x = 72.182487, y = 32.718285, z = -72.311913 },

					attributes =
					{
						Input = "Left Aileron",
						Length = 0.39,
						Tip_distance = 0.0,
						Root_chord = 0.14,
						Tip_chord = 0.13,
						Min_travel = 40.0,
						Max_travel = 40.0,
					},

					sides =
					{
						{

							"left_aileron",
						},

						{

							"right_aleron",
						},

					},

				},

			},

			flaps = {

				{
					name = "Flap",
					root_pivot = { x = 44.805496, y = 34.185249, z = -13.168285 },
					tip_pivot = { x = 74.137009, y = 32.658703, z = -64.639465 },
					is_leading_edge = 0,

					attributes =
					{
						Length = 0.5,
						Root_Chord = 0.15,
						Tip_Chord = 0.15,
						Tip_distance = 0.0,
						Travel = -30.0,
						Lift_increase = 25.0,
						Drag_increase = 25.0,
					},

					sides =
					{
						{

							"left_flap",
						},

						{

							"right_flap",
						},

					},

				},

			},

			airbrakes = {

			},

		},

		{
			name = "canards",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 18.32268, y = 35.519238, z = 62.015011 },
				Length = 0.53,
				Root_chord = 0.23,
				Tip_chord = 0.23,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 59.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = -27.144207, y = 35.58165, z = 46.729744 },
					tip_pivot = { x = 27.067631, y = 36.008652, z = 46.698189 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.53,
						Tip_distance = 0.0,
						Root_chord = 0.23,
						Tip_chord = 0.23,
						Min_travel = -20.0,
						Max_travel = -20.0,
					},

					sides =
					{
						{

							"left_canard",
								"right_canard",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "fin",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 27.848497, y = 35.816063, z = -60.016232 },
				Length = 0.63,
				Root_chord = 0.53,
				Tip_chord = 0.38,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 60.0,
				Sweep = 56.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "left rudder control Surface",
					root_pivot = { x = 29.492544, y = 38.202057, z = -102.274643 },
					tip_pivot = { x = 45.003052, y = 66.277596, z = -135.213608 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.61,
						Tip_distance = 0.0,
						Root_chord = 0.14,
						Tip_chord = 0.14,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"left_rudder",
						},

						{

						},

					},

				},

				{
					name = "right rudder Control Surface",
					root_pivot = { x = -29.488955, y = 38.386906, z = -102.225494 },
					tip_pivot = { x = -42.137932, y = 60.458271, z = -128.826385 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.61,
						Tip_distance = 0.0,
						Root_chord = 0.14,
						Tip_chord = 0.14,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"right_rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "stabilisator",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 31.217913, y = 32.30648, z = -95.439255 },
				Length = 0.26,
				Root_chord = 0.15,
				Tip_chord = 0.15,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = -30.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

				{
					name = "Control surface",
					root_pivot = { x = 31.09712, y = 32.386421, z = -95.550674 },
					tip_pivot = { x = 53.612938, y = 32.324429, z = -82.294609 },

					attributes =
					{
						Input = "Left Elevator",
						Length = 0.26,
						Tip_distance = 0.0,
						Root_chord = 0.15,
						Tip_chord = 0.15,
						Min_travel = 40.0,
						Max_travel = 40.0,
					},

					sides =
					{
						{

							"left_elevator",
						},

						{

							"right_elevator",
						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	propulsion = 
	{

		{
			name = "leftTurbine",
			type = "turbine",

			attributes =
			{
				Position = { x = 15.667621, y = 27.285019, z = 0.239991 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 200.0,
				Spool_Time = 5.0,
				Throttle_Curve = 1.0,
				Engine = "Scale turbine",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 300.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust",
					position = { x = 92.420074, y = 31.754719, z = -99.765862 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

		{
			name = "right Turbine",
			type = "turbine",

			attributes =
			{
				Position = { x = -15.000615, y = 27.453556, z = 0.24015 },
				Idle_RPM = 40000.0,
				Max_RPM = 120000.0,
				Idle_Thrust = 0.0,
				Max_Thrust = 200.0,
				Spool_Time = 5.0,
				Throttle_Curve = 1.0,
				Engine = "Scale turbine",
				Volume_Tuning = 80.0,
				Pitch_Tuning = 30.0,
			},

			exhaust = 
			{

				{
					name = "New Exhaust2",
					position = { x = -93.730286, y = 32.015244, z = -99.672768 },
					vector = { x = 0.0, y = 0.0, z = 1.0 },

					attributes =
					{
						Engine_Smoke = 0,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 1,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "front Gear",
			root_pivot = { x = 5.533526, y = 34.049953, z = 53.936329 },
			tip_pivot = { x = -6.042892, y = 34.047852, z = 53.912922 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 2000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -100.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Su_37_Terminator_turbine:train_d_attrissage:FrontGear",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "New Wheel",
					pivot = { x = -0.0, y = 4.306561, z = 59.793514 },
					axis = { x = 1.0, y = 0.0, z = -0.0 },
					width = 9.189926,
					radius = 4.24549,

					sides =
					{
						{

							"Su_37_Terminator_turbine:train_d_attrissage:FrontWheels",
						},

					},

				},

			},

		},

		{
			name = "rear Gear",
			root_pivot = { x = 30.748587, y = 28.369953, z = -42.702545 },
			tip_pivot = { x = 25.141451, y = 28.374302, z = -40.823208 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 1,
			isRetractable = 1,
			changeTime = 2000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -100.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"Su_37_Terminator_turbine:train_d_attrissage:verrain_bas_train_g",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"Su_37_Terminator_turbine:train_d_attrissage:verrain_bas_train_d",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "New Wheel2",
					pivot = { x = 33.773159, y = 6.905711, z = -41.985931 },
					axis = { x = 1.0, y = -0.0, z = 0.0 },
					width = 4.303509,
					radius = 6.723492,

					sides =
					{
						{

							"Su_37_Terminator_turbine:train_d_attrissage:LeftRearWheel",
						},

						{

							"Su_37_Terminator_turbine:train_d_attrissage:RightRearWheel",
						},

					},

				},

			},

		},

	},

	widgets = 
	{

		{
			name = "front trap",
			root_pivot = { x = 3.342296, y = 29.214182, z = 63.358723 },
			tip_pivot = { x = -3.359257, y = 29.212152, z = 63.352779 },
			mirrored = 0,
			changeTime = 2000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"front_trap",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "left front trap",
			root_pivot = { x = 5.054823, y = 24.663715, z = 28.118345 },
			tip_pivot = { x = 3.681432, y = 28.017944, z = 52.565598 },
			mirrored = 1,
			changeTime = 2000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -90.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"left_front_trap",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"righ_front_trap",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "rear trap 1",
			root_pivot = { x = 30.911457, y = 32.318336, z = -69.861786 },
			tip_pivot = { x = 35.380383, y = 32.228336, z = -44.1912 },
			mirrored = 1,
			changeTime = 2000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -35.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"left_rear_trap1",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"right_rear_trap1",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "rear trap 2",
			root_pivot = { x = 26.581326, y = 16.426338, z = -44.979271 },
			tip_pivot = { x = 26.581326, y = 16.426338, z = -38.891598 },
			mirrored = 1,
			changeTime = 2000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 150.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"left_rear_trap3",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"rright_rear_trap3",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "aerofrein",
			root_pivot = { x = 4.408812, y = 51.196941, z = 28.194729 },
			tip_pivot = { x = -4.205585, y = 51.194843, z = 28.204462 },
			mirrored = 0,
			changeTime = 1000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 27.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"aerofrein",
					},

					collision = 
					{

					},

				},

			},

		},

		{
			name = "piston aerofrein",
			root_pivot = { x = 1.307277, y = 37.321888, z = -13.185492 },
			tip_pivot = { x = -1.390483, y = 37.31982, z = -13.181067 },
			mirrored = 0,
			changeTime = 1000.0,
			input = "None",
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = -20.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			sides =
			{
				{

					geometry = 
					{

						"piston_aerofrein",
					},

					collision = 
					{

					},

				},

			},

		},

	},

}